% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proxy.R
\name{dock_view_proxy}
\alias{dock_view_proxy}
\title{Create a proxy object to modify an existing dockview instance}
\usage{
dock_view_proxy(id, data = NULL, session = getDefaultReactiveDomain())
}
\arguments{
\item{id}{Character string matching the ID of the dockview instance to be modified.}

\item{data}{Unused parameter (for future compatibility).}

\item{session}{The Shiny session object within which the graph exists.
By default, this uses the current reactive domain.}
}
\value{
A proxy object of class "dock_view_proxy" that can be used with dockview proxy methods
such as \code{add_panel()}, \code{remove_panel()}, etc. It contains:
\itemize{
\item \code{id}: The ID of the dockview instance.
\item \code{session}: The Shiny session object.
}
}
\description{
This function creates a proxy object that can be used to update an existing dockview
instance after it has been rendered in the UI. The proxy allows for server-side
modifications of the graph without completely re-rendering it.
}
