% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-fancyFileInput.R
\name{fancyFileInput}
\alias{fancyFileInput}
\title{Shiny drag-and-drop file input}
\usage{
fancyFileInput(
  inputId,
  label,
  width = NULL,
  after_content = "Drag & drop, or button",
  size = c("s", "m", "l", "xl"),
  maxSize = NULL,
  ...
)
}
\arguments{
\item{inputId}{the input slot that will be used to access the value}

\item{label}{display label for the control, or NULL for no label.}

\item{width}{the width of the input}

\item{after_content}{tiny content that is to be displayed below the input box}

\item{size}{height of the widget, choices are \code{'s'}, \code{'m'}, \code{'l'}, and \code{'xl'}}

\item{maxSize}{maximum file size per file in bytes (default uses \code{shiny.maxRequestSize} option, typically 5MB)}

\item{...}{passed to \code{\link[shiny]{fileInput}}}
}
\value{
See \code{\link[shiny]{fileInput}}
}
\description{
Fancy drag and drop file upload for \code{shiny} apps.
}
\examples{


library(shiny)
library(dipsaus)

ui <- basicPage(
  fancyFileInput('file_input', "Please upload")
)

if(interactive()) {
  shinyApp(
    ui, server = function(input, output, session){},
    options = list(launch.browser = TRUE)
  )
}

}
