% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hybridIndex.r
\name{hybridIndex}
\alias{hybridIndex}
\title{Compute hybrid index from genotypes, file, or numeric vector}
\usage{
hybridIndex(x, ChosenInds = "all", rescale = FALSE)
}
\arguments{
\item{x}{Either a genotype matrix/data.frame, a path to a text file
produced by \code{diem}, or a numeric vector of hybrid indices.}

\item{ChosenInds}{A numeric or logical vector of indices of individuals to be included
in the analysis.}

\item{rescale}{Logical, whether to linearly rescale the resulting hybrid
indices to the interval 0–1. Defaults to \code{FALSE}.}
}
\value{
A numeric vector of hybrid index values. Names are not preserved.
}
\description{
Provides a unified way to obtain the hybrid index
regardless of the data source. It accepts:
\itemize{
\item a genotype matrix or data frame or the I4 matrix and computes the hybrid indices using
\code{sStateCount()} and \code{pHetErrOnStateCount()};
\item a file with hybrid index values, typically generated by \code{diem()};
\item or a numeric vector of values.
}
}
\details{
The function returns a numeric vector of hybrid indices and can
optionally subset individuals or rescale the values to the range 0-1.

The function automatically detects the input type:
\itemize{
\item \strong{File path} - the file is expected to have hybrid indices in the last
column, that can optionally be named \code{"HybridIndex"}.
\item \strong{Numeric vector} - values are passed through unchanged.
\item \strong{Genotype matrix} - typically polarised genotypes resulting from
\code{importPolarized}, with rows representing individuals. Each row is
processed by \code{pHetErrOnStateCount(sStateCount(row))}.
}

If \code{rescale = TRUE}, values are mapped to \deqn{[0, 1]} unless all are equal
or non-finite, in which case the original values are returned with a warning.
}
\examples{
hybridIndex(c(0.3, 0.5, 0.7))

hybridIndex(1:10, ChosenInds = 1:5, rescale = TRUE)

}
\seealso{
\link{pHetErrOnStateCount}, \link{sStateCount}
}
