% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_mixture.R
\name{mixture}
\alias{mixture}
\title{Mixture of penalization terms}
\usage{
mixture(range = c(0, 1), trans = NULL)
}
\arguments{
\item{range}{A two-element vector holding the \emph{defaults} for the smallest and
largest possible values, respectively. If a transformation is specified,
these values should be in the \emph{transformed units}.}

\item{trans}{A \code{trans} object from the \code{scales} package, such as
\code{scales::transform_log10()} or \code{scales::transform_reciprocal()}. If not provided,
the default is used which matches the units used in \code{range}. If no
transformation, \code{NULL}.}
}
\description{
A numeric parameter function representing the relative amount of penalties
(e.g. L1, L2, etc) in regularized models.
}
\details{
This parameter is used for regularized or penalized models such as
\code{parsnip::linear_reg()}, \code{parsnip::logistic_reg()}, and others. It is
formulated as the proportion of L1 regularization (i.e. lasso) in the model.
In the \code{glmnet} model, \code{mixture = 1} is a pure lasso model while \code{mixture = 0}
indicates that ridge regression is being used.
}
\examples{
mixture()
}
