% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_buffer.R
\name{buffer}
\alias{buffer}
\title{Buffer size}
\usage{
buffer(range = c(0, 0.5), trans = NULL)
}
\arguments{
\item{range}{A two-element vector holding the \emph{defaults} for the smallest and
largest possible values, respectively. If a transformation is specified,
these values should be in the \emph{transformed units}.}

\item{trans}{A \code{trans} object from the \code{scales} package, such as
\code{scales::transform_log10()} or \code{scales::transform_reciprocal()}. If not provided,
the default is used which matches the units used in \code{range}. If no
transformation, \code{NULL}.}
}
\description{
In equivocal zones, predictions are considered equivocal (i.e. "could
go either way") if their probability falls within some distance on either
side of the classification threshold. That distance is called the "buffer."
}
\details{
A buffer of .5 is only possible if the classification threshold is .5.
In that case, all probability predictions are considered equivocal,
regardless of their value in \code{[0, 1]}.
Otherwise, the maximum buffer is \code{min(threshold, 1 - threshold)}.
}
\examples{
buffer()
}
\seealso{
\code{\link[=threshold]{threshold()}}
}
