% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t_test_paired.r
\name{t_test_paired}
\alias{t_test_paired}
\title{Paired and one-sample t-Tests}
\usage{
t_test_paired(data, alternative = "two.sided", ci_level = NULL, mean_null = 0)
}
\arguments{
\item{data}{(list)\cr
A list whose first element is the vector of normal values from sample
1 and the second element is the vector of normal values from sample 2.
Both vectors must be the same sample size and sorted by the
subject/item index. If \code{length(data) == 1L}, the one-sample test is
used. \link[base]{NA}s are silently excluded. The default output
from \code{\link[=sim_log_lognormal]{sim_log_lognormal()}}.}

\item{alternative}{(string: \code{"two.sided"})\cr
The alternative hypothesis. Must be one of \code{"two.sided"}, \code{"greater"},
or \code{"less"}. See 'Details' for additional information.}

\item{ci_level}{(Scalar numeric: \code{NULL}; \verb{(0, 1)})\cr
If \code{NULL}, confidence intervals are set as \code{NA}. If in \verb{(0, 1)},
confidence intervals are calculated at the specified level.}

\item{mean_null}{(Scalar numeric: \code{0}; \verb{(-Inf, Inf)})\cr
The mean or mean difference assumed under the null hypothesis. See
'Details' for additional information.}
}
\value{
A list with the following elements:
\tabular{llll}{
Slot \tab Subslot \tab Name \tab Description \cr
1 \tab   \tab \code{t}  \tab Value of the t-statistic. \cr
2 \tab   \tab \code{df} \tab Degrees of freedom for the t-statistic. \cr
3 \tab   \tab \code{p}  \tab p-value. \cr

4 \tab   \tab \code{mean_diff} \tab Estimated mean or mean of the differences
(sample 2 – sample 1). \cr
4 \tab 1 \tab \code{estimate}  \tab Point estimate. \cr
4 \tab 2 \tab \code{lower}     \tab Confidence interval lower bound. \cr
4 \tab 3 \tab \code{upper}     \tab Confidence interval upper bound. \cr

5 \tab   \tab \code{n}           \tab Number of paired observations. \cr
6 \tab   \tab \code{method}      \tab Method used for the results. \cr
7 \tab   \tab \code{alternative} \tab The alternative hypothesis. \cr
8 \tab   \tab \code{ci_level}    \tab The confidence level. \cr
9 \tab   \tab \code{mean_null}   \tab Assumed population mean of the differences
under the null hypothesis.
}
}
\description{
Performs paired and one-sample t-Tests.
}
\details{
This function is primarily designed for speed in simulation. Missing values
are silently excluded.

The one-sample test is used for both the true one-sample scenario and for the
paired differences from a dependent two-sample scenario. Below we use paired
difference language as that is the most common case. The hypotheses for the
paired t-test are

\deqn{
\begin{aligned}
H_{null} &: \mu_{diff} = \mu_{null} \\
H_{alt} &: \begin{cases}
  \mu_{diff} \neq \mu_{null} & \text{two-sided}\\
  \mu_{diff} > \mu_{null} & \text{greater than}\\
  \mu_{diff} < \mu_{null} & \text{less than}
\end{cases}
\end{aligned}
}

where \eqn{\mu_{diff} = AM(X_2 - X_1)} is the arithmetic mean of the paired
differences (sample 2 - sample 1) and \eqn{\mu_{null}} is a constant for the
assumed population mean difference (usually \eqn{\mu_{null} = 0}).

The test statistic is

\deqn{
T = \frac{\bar{x}_{diff} - \mu_{null}}{\sqrt{\frac{s^2}{n}}}
}

where \eqn{\bar{x}_{diff}} is the sample mean of the differences, \eqn{\mu_{null}}
is the population mean difference assumed under the null hypothesis, \eqn{n}
is the sample size of the differences, and \eqn{s^2} is the sample variance.

The critical value of the test statistic has degrees of freedom

\deqn{
df = n-1
}

and the p-value is calculated as

\deqn{
\begin{aligned}
p &= \begin{cases}
  2 \text{min} \{P(T \geq t_{n-1} \mid H_{null}), P(T \leq t_{n-1} \mid H_{null})\} & \text{two-sided}\\
  P(T \geq t_{n-1} \mid H_{null}) & \text{greater than}\\
  P(T \leq t_{n-1} \mid H_{null}) & \text{less than}
\end{cases}
\end{aligned}
}

Let \eqn{GM(\cdot)} be the geometric mean and \eqn{AM(\cdot)} be the
arithmetic mean. For dependent lognormal samples \eqn{X_1} and \eqn{X_2} it
follows that \eqn{\ln X_1} and \eqn{\ln X_2} are dependent normally
distributed variables. Setting \eqn{\mu_{diff} = AM(\ln X_2 - \ln X_1)}
we have

\deqn{
e^{\mu_{diff}} = GM\left( \frac{X_2}{X_1} \right)
}

This forms the basis for making inference about the geometric mean ratio of
the original lognormal data using the mean difference of the log transformed
normal data.
}
\examples{
#----------------------------------------------------------------------------
# t_test_paired() examples
#----------------------------------------------------------------------------
library(depower)

# One-sample t-test
set.seed(1234)
t_test1 <- sim_log_lognormal(
  n1 = 40,
  ratio = 1.5,
  cv1 = 0.4
) |>
  t_test_paired(ci_level = 0.95)

t_test1

# Paired t-test using two dependent samples
set.seed(1234)
t_test2 <- sim_log_lognormal(
  n1 = 40,
  n2 = 40,
  ratio = 1.5,
  cv1 = 0.4,
  cv2 = 0.2,
  cor = 0.3
) |>
  t_test_paired(ci_level = 0.95)

t_test2

}
\references{
\insertRef{julious_2004}{depower}

\insertRef{hauschke_1992}{depower}

\insertRef{johnson_1994}{depower}
}
\seealso{
\code{\link[=t_test_welch]{t_test_welch()}}
}
