% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deepspat_main_rPP.R
\name{deepspat_rPP}
\alias{deepspat_rPP}
\title{Deep compositional spatial model for r-Pareto processes}
\usage{
deepspat_rPP(
  f,
  data,
  layers = NULL,
  method = c("WLS", "GSM"),
  par_init = initvars(),
  learn_rates = init_learn_rates(),
  family = c("power_stat", "power_nonstat"),
  dtype = "float32",
  nsteps = 100L,
  nsteps_pre = 100L,
  edm_emp = NULL,
  risk = NULL,
  thre = NULL,
  weight_fun = NULL,
  dWeight_fun = NULL,
  pen_coef = 0,
  show = TRUE,
  ...
)
}
\arguments{
\item{f}{A formula identifying the dependent variable(s) and the spatial inputs. Use \code{get_depvars_multivar3} to extract the dependent variable names.}

\item{data}{A data frame containing the required data.}

\item{layers}{A list containing the warping layers; required for non-stationary models (i.e., when \code{family = "power_nonstat"}).}

\item{method}{A character string specifying the estimation method. Must be one of \code{"GSM"}, or \code{"WLS"} for r-Pareto processes}

\item{par_init}{A list of initial parameter values. Call the function \code{initvars()} to see the structure of the list.}

\item{learn_rates}{A list of learning rates for the various quantities in the model. Call the function \code{init_learn_rates()}
to see the structure of the list.}

\item{family}{A character string specifying the spatial dependence model. Use \code{"power_nonstat"} for non-stationary models
and \code{"sta"} for stationary models.}

\item{dtype}{A character string indicating the data type for TensorFlow computations (\code{"float32"} or \code{"float64"}).
Default is \code{"float32"}}

\item{nsteps}{An integer specifying the number of training steps for dependence parameter learning.}

\item{nsteps_pre}{An integer specifying the number of pre-training steps for warping layer parameters.}

\item{edm_emp}{For the LS method, a numeric vector or matrix providing an empirical conditional exceedance probabilities.}

\item{risk}{For the GS method, a numeric value indicating the risk parameter.}

\item{thre}{A numeric threshold used in the GS method.}

\item{weight_fun}{A function used to weight pairwise differences in the GS method.}

\item{dWeight_fun}{A function representing the derivative of \code{weight_fun} (used in the GS method).}

\item{pen_coef}{A penalty parameter for weights of SR-RBF(2) to relieve overfitting.}

\item{show}{Logical; if \code{TRUE} progress information is printed during training.}

\item{...}{Currently unused.}
}
\value{
\code{deepspat_rPP} returns an object of class \code{deepspat_rPP} which is a list containing the following components:
\describe{
  \item{\code{layers}}{The list of warping layers used in the model.}
  \item{\code{Cost}}{The final cost value after training (e.g., negative log-likelihood, least squares, or gradient score).}
  \item{\code{transeta_tf}}{TensorFlow objects for the transformed dependence parameters in the warping layers.}
  \item{\code{eta_tf}}{TensorFlow objects for the warped dependence parameters.}
  \item{\code{a_tf}}{TensorFlow object for the parameters of the LFT layers (if applicable).}
  \item{\code{logphi_tf}}{TensorFlow variable representing the logarithm of the spatial range parameter.}
  \item{\code{logitkappa_tf}}{TensorFlow variable representing the logit-transformed degrees of freedom.}
  \item{\code{scalings}}{A list of scaling limits (minima and maxima) for the input and warped spatial coordinates.}
  \item{\code{s_tf}}{TensorFlow object for the scaled spatial coordinates.}
  \item{\code{z_tf}}{TensorFlow object for the observed response values.}
  \item{\code{u_tf}}{TensorFlow object for the threshold used in the GS method (if applicable).}
  \item{\code{swarped_tf}}{List of TensorFlow objects representing the warped spatial coordinates at each layer.}
  \item{\code{swarped}}{Matrix of final warped spatial coordinates.}
  \item{\code{method}}{The estimation method used (\code{"WLS"} or \code{"GSM"}).}
  \item{\code{risk}}{The risk parameter used in the GS method (if applicable).}
  \item{\code{family}}{The spatial dependence family (\code{"power_stat"} or \code{"power_nonstat"}).}
  \item{\code{dtype}}{The data type used in TensorFlow computations.}
  \item{\code{nlayers}}{Number of warping layers (for non-stationary models).}
  \item{\code{weight_fun}}{The weighting function used in the GS method.}
  \item{\code{dWeight_fun}}{The derivative of the weighting function used in the GS method.}
  \item{\code{f}}{The model formula.}
  \item{\code{data}}{The data frame used for model fitting.}
  \item{\code{negcost}}{Vector of cost values recorded during training.}
  \item{\code{pairs_tf}}{TensorFlow variable representing the spatial location pairs
    (and, for MRPL, the replicate indices) used in the pairwise / randomized pairwise
    likelihood or WLS objective..}
  \item{\code{pairs_t_tf}}{Tranposed pairs_tf.}
  \item{\code{time}}{Elapsed time for model fitting.}
}
}
\description{
Constructs an extended deep compositional spatial model that supports different estimation methods
  ("GSM" or "WLS") and spatial dependence families (stationary or non-stationary). This function extends the
  basic deepspat model by incorporating additional dependence modeling and pre-training steps for the warping layers.
}
