% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets_doc_for_CRAN.R
\docType{data}
\name{eel_cat_3lvl_data}
\alias{eel_cat_3lvl_data}
\title{Data summarizing the evolution of feeding habits in eels using a 3-level factor as categorical trait}
\format{
A list with 6 elements.
}
\usage{
data(eel_cat_3lvl_data)
}
\description{
A list containing feeding habits data of eels mapped on the phylogeny,
modeled with \link[geiger:fitDiscrete]{geiger::fitDiscrete}. This object was obtained with \code{\link[=prepare_trait_data]{prepare_trait_data()}}.
Initial data was altered arbitrarily to create three categories, adding a "kiss" feeding habit to the initial
"bite" and "suction" data. This is NOT real biological data. Please refer to the initial article for real data.

Original data source: Collar, D. C., P. C. Wainwright, M. E. Alfaro, L. J. Revell, and R. S. Mehta (2014) Biting disrupts integration to spur skull evolution in eels. Nature Communications, 5, 5505.
\doi{10.1038/ncomms6505}
}
\details{
A list of five objects containing information on the evolution of feeding habits in eels.
This object was obtained with \code{\link[=prepare_trait_data]{prepare_trait_data()}}.
\itemize{
\item \verb{$densityMaps} List of objects of class \verb{"densityMap} that contains a phylogenetic tree and associated mapping of probability
to harbor a given state/range along branches. The list contains one \verb{"densityMap} per state/range found in the \code{tip_data}.
\item \verb{$trait_data_type} Character string. Record the type of trait data. Here: "categorical".
\item \verb{$simmaps} List of 100 stochastic mapping simulations for trait evolution. Each element is a \code{"simmap"} object (see \link[phytools:make.simmap]{phytools::make.simmap})
representing a possible evolutionary history that fits states observed on tips, infered ACE at internal nodes, and transition rates as estimated from the best fit model.
\item \verb{$ace} Numerical matrix that record the posterior probabilities of ancestral states/ranges (characters) estimates (ACE) at internal nodes.
Rows are internal nodes. Columns are states/ranges. Values are posterior probabilities of each state per node.
\item \verb{$best_model_fit} List that provides the output of the best fitting model (Here: ER model).
\item \verb{$model_selection_df} Data.frame that summarizes model comparisons used to select the best fitting model.
}
}
\references{
Collar, D. C., P. C. Wainwright, M. E. Alfaro, L. J. Revell, and R. S. Mehta (2014) Biting disrupts integration to spur skull evolution in eels. Nature Communications, 5, 5505.
\doi{10.1038/ncomms6505}
}
\seealso{
\code{\link[=prepare_trait_data]{prepare_trait_data()}}
}
\keyword{datasets}
