% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plate-attribs.R
\name{check_step}
\alias{check_step}
\title{Ensure the plate's status is at the right step}
\usage{
check_step(plate, step)
}
\description{
Before beginning a step, you can check to make sure the plate is currently
at most one step behind the current step. If the plate is more than one step
behind, an error will be thrown, so that the user will know they need to
run the previous steps.
}
\examples{
\dontrun{
dir <- sample_data_dir()
plate <- new_plate(dir)
status(plate) # current step
check_step(plate, 2) # are we ready to start step 2?
check_step(plate, 3) # are we ready to start step 3?
plate <- next_step(plate)
status(plate)
check_step(plate, 3) # now are we ready to start step 3?
}
}
\keyword{internal}
