% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schema.R
\name{in_schema}
\alias{in_schema}
\alias{in_catalog}
\title{Refer to a table in another schema/catalog}
\usage{
in_schema(schema, table)

in_catalog(catalog, schema, table)
}
\arguments{
\item{catalog, schema, table}{Names of catalog, schema, and table.
These will be automatically quoted; use \code{\link[=sql]{sql()}} to pass a raw name
that won't get quoted.}
}
\description{
\code{in_schema()} and \code{in_catalog()} can be used to refer to tables outside of
the current catalog/schema. However, we now recommend using \code{I()} as it's
typically less typing.
}
\examples{
# Previously:
in_schema("my_schema", "my_table")
in_catalog("my_catalog", "my_schema", "my_table")
in_schema(sql("my_schema"), sql("my_table"))

# Now
I("my_schema.my_table")
I("my_catalog.my_schema.my_table")
I("my_schema.my_table")

# Example using schemas with SQLite
con <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")

# Add auxiliary schema
tmp <- tempfile()
DBI::dbExecute(con, paste0("ATTACH '", tmp, "' AS aux"))

library(dplyr, warn.conflicts = FALSE)
copy_to(con, iris, "df", temporary = FALSE)
copy_to(con, mtcars, I("aux.df"), temporary = FALSE)

con \%>\% tbl("df")
con \%>\% tbl(I("aux.df"))
}
\keyword{internal}
