% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_helpers.R
\name{merge_drugbank_onsides}
\alias{merge_drugbank_onsides}
\title{Merge DrugBank and OnSIDES Database Objects}
\usage{
merge_drugbank_onsides(db_object, onsides_db)
}
\arguments{
\item{db_object}{A dvobject from `parseDrugBank()` OR an existing merged
dvobject (containing `$drugbank`).}

\item{onsides_db}{A dvobject produced by `dbparser::parseOnSIDES()`.}
}
\value{
A new dvobject containing the integrated data.
}
\description{
Creates an integrated dvobject object by linking DrugBank dvobject with
OnSIDES dvobject using RxNorm CUIs as the bridge.
}
\details{
This function performs the following key steps:
1. Creates a mapping table between DrugBank IDs and RxNorm CUIs from the DrugBank object.
2. Enriches the relevant OnSIDES tables (`vocab_rxnorm_ingredient` and optionally
   `high_confidence`) by adding a `drugbank_id` column.
3. Assembles a new list object containing all original tables plus the enriched ones
   and the ID mapping table itself.

The resulting object allows for powerful queries that span both mechanistic data from
DrugBank and clinical side-effect data from OnSIDES.
Supports piping and chaining with other merge functions.
}
\examples{
\dontrun{
# First, parse the individual databases
drugbank <- parseDrugBank("path/to/drugbank.xml")
onsides <- parseOnSIDES("path/to/onsides_csvs/")

# Now, merge them into a single, powerful object
merged_db <- merge_drugbank_onsides(drugbank, onsides)

# --- Example Analysis: Find the protein targets of all drugs known to ---
# --- cause the side effect "Hepatitis" with high confidence.        ---

# 1. Find the MedDRA ID for "Hepatitis"
hepatitis_id <- merged_db$onsides$vocab_meddra_adverse_effect \%>\%
  filter(meddra_name == "Hepatitis") \%>\%
  pull(meddra_id)

# 2. Find all drug ingredients linked to this effect in the high_confidence table
drug_ids_causing_hepatitis <- merged_db$onsides$high_confidence_enriched \%>\%
  filter(effect_meddra_id == hepatitis_id) \%>\%
  pull(drugbank_id) \%>\%
  na.omit() \%>\%
  unique()

# 3. Look up the targets for these DrugBank IDs
targets_of_interest <- merged_db$targets \%>\%
  filter(parent_key \%in\% drug_ids_causing_hepatitis) \%>\%
  select(drug_id = parent_key, target_name = name, gene_name)

head(targets_of_interest)
}
}
\seealso{
Other mergers: 
\code{\link{merge_drugbank_twosides}()}
}
\concept{mergers}
