% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dt_modification.R
\name{filter_same_cycle}
\alias{filter_same_cycle}
\title{Filter the instances in a data.table with different ids in each row}
\usage{
filter_same_cycle(f_dt, size, id_var)
}
\arguments{
\item{f_dt}{folded data.table}

\item{size}{the size of the data.table}

\item{id_var}{the variable that labels each individual instance of the time series}
}
\value{
the filtered data.table
}
\description{
Given an id variable that labels the different instances of a time series
inside a dataset, discard the rows that have values from more than 1 id.
}
\examples{
dt <- dbnR::motor[201:2500]
dt[, n_sec := rep(seq(46), each = 50)] # I'll create secuences of 50 instances each
f_dt <- dbnR::fold_dt(dt, size = 2)
f_dt[50, .SD, .SDcols = c("n_sec_t_0", "n_sec_t_1")]
f_dt <- dbnR::filter_same_cycle(f_dt, size = 2, id_var = "n_sec")
f_dt[50, .SD, .SDcols = c("n_sec_t_0", "n_sec_t_1")]
}
