% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Models.R
\name{SetPredictionThreshold}
\alias{SetPredictionThreshold}
\title{Set a custom prediction threshold for binary classification models.}
\usage{
SetPredictionThreshold(model, threshold)
}
\arguments{
\item{model}{An S3 object of class dataRobotModel like that returned by
the function GetModel, or each element of the list returned by
the function ListModels.}

\item{threshold}{numeric. The threshold to use when deciding between the positive and
negative class. Should be between 0 and 1 inclusive.}
}
\value{
Returns NULL but updates the model in place.
}
\description{
The prediction threshold is used by a binary classification model when deciding between
the positive and negative class.
}
\details{
Note: This feature can only can be used when \code{PredictionThresholdReadOnly} is \code{FALSE}.
Models typically cannot have their prediction threshold modified if they have been used to
set a deployment or predictions have been made with the dedicated prediction API.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  modelId <- "5996f820af07fc605e81ead4"
  model <- GetModel(projectId, modelId)
  SetPredictionThreshold(model, threshold = 0.6)
}
}
