% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/con_inadmissible_categorical.R
\name{con_inadmissible_categorical}
\alias{con_inadmissible_categorical}
\title{Detects variable levels not specified in metadata}
\usage{
con_inadmissible_categorical(
  resp_vars = NULL,
  study_data,
  label_col,
  item_level = "item_level",
  threshold_value = 0,
  meta_data = item_level,
  meta_data_v2
)
}
\arguments{
\item{resp_vars}{\link{variable list} the name of the measurement variables}

\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{item_level}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{threshold_value}{\link{numeric} from=0 to=100. a numerical value ranging
from 0-100.}

\item{meta_data}{\link{data.frame} old name for \code{item_level}}

\item{meta_data_v2}{\link{character} path to workbook like metadata file, see
\code{\link{prep_load_workbook_like_file}} for details.
\strong{ALL LOADED DATAFRAMES WILL BE PURGED},
using \code{\link{prep_purge_data_frame_cache}},
if you specify \code{meta_data_v2}.}
}
\value{
a list with:
\itemize{
\item \code{SummaryData}: data frame summarizing inadmissible categories with the
columns:
\itemize{
\item \code{Variables}: variable name/label
\item \code{OBSERVED_CATEGORIES}: the categories observed in the study data
\item \code{DEFINED_CATEGORIES}: the categories defined in the metadata
\item \code{NON_MATCHING}: the categories observed but not defined
\item \code{NON_MATCHING_N}: the number of observations with categories not defined
\item \code{NON_MATCHING_N_PER_CATEGORY}: the number of observations for each of the
unexpected categories
}
\item \code{SummaryTable}: data frame for the \code{dataquieR} pipeline reporting the number
and percentage of inadmissible categorical values
\item \code{ModifiedStudyData}: study data having inadmissible categories removed
\item \code{FlaggedStudyData}: study data having cases with inadmissible categories
flagged
}
}
\description{
For each categorical variable, value lists should be defined in the metadata.
This implementation will examine, if all observed levels in the study data
are valid.

\link{Indicator}
}
\details{
\subsection{Algorithm of this implementation:}{
\itemize{
\item Remove missing codes from the study data (if defined in the metadata)
\item Interpretation of variable specific VALUE_LABELS as supplied in the
metadata.
\item Identification of measurements not corresponding to the expected
categories. Therefore two output data frames are generated:
\itemize{
\item on the level of observation to flag each undefined category, and
\item a summary table for each variable.
}
\item Values not corresponding to defined categories are removed in a data frame
of modified study data
}
}
}
\seealso{
\href{https://dataquality.qihs.uni-greifswald.de/VIN_con_impl_inadmissible_categorical.html}{Online Documentation}
}
