% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_robust_guess_data_type.R
\name{util_verify_encoding}
\alias{util_verify_encoding}
\title{Verify encoding}
\usage{
util_verify_encoding(dt0, ref_encs)
}
\arguments{
\item{dt0}{\link{data.frame} data to verify}

\item{ref_encs}{\link{character} names are column names of \code{dt0}, values their
expected encoding, can be missing.}
}
\description{
Verify encoding
}
\examples{
\dontrun{
  dt0 <-
    prep_get_data_frame(
    file.path("~",
      "rsync", "nako_mrt_qs$", "exporte", "NAKO_Datensatz_bereinigte_Daten",
      "NatCoEdc_Export", "export_mannheim_30.csv"))
  util_verify_encoding(dt0)
  dt0$mrt_note[[1]] <- iconv("Härbärt", "UTF-8", "cp1252")
  util_verify_encoding(dt0)
  dt0$mrt_note[[15]] <- iconv("Härbärt", "UTF-8", "cp1252")
  util_verify_encoding(dt0)
  dt0$mrt_note[[1]] <- "Härbärt"
  util_verify_encoding(dt0)
  dt0$mrt_note[[17]] <- iconv("Härbärt", "UTF-8", "latin3")
  util_verify_encoding(dt0)
}
}
\keyword{internal}
