% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/int_unexp_records_segment.R
\name{int_unexp_records_segment}
\alias{int_unexp_records_segment}
\title{Check for unexpected data record count within segments}
\usage{
int_unexp_records_segment(
  study_segment,
  study_data,
  label_col,
  item_level = "item_level",
  data_record_count,
  meta_data = item_level,
  meta_data_segment = "segment_level",
  meta_data_v2,
  segment_level
)
}
\arguments{
\item{study_segment}{\link{character} a character vector indicating the name of each study data frame, mandatory.}

\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{item_level}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{data_record_count}{\link{integer}  an integer vector with the number of expected data records, mandatory.}

\item{meta_data}{\link{data.frame} old name for \code{item_level}}

\item{meta_data_segment}{\link{data.frame} -- optional: Segment level metadata}

\item{meta_data_v2}{\link{character} path to workbook like metadata file, see
\code{\link{prep_load_workbook_like_file}} for details.
\strong{ALL LOADED DATAFRAMES WILL BE PURGED},
using \code{\link{prep_purge_data_frame_cache}},
if you specify \code{meta_data_v2}.}

\item{segment_level}{\link{data.frame} alias for \code{meta_data_segment}}
}
\value{
a \link{list} with
\itemize{
\item \code{SegmentData}: data frame with the results of the quality check for unexpected data elements
\item \code{SegmentTable}: data frame with selected unexpected data elements check results, used for the data quality report.
}
}
\description{
This function contrasts the expected record number in each study segment in
the metadata with the actual record number in each segment data frame.

\link{Indicator}
}
\details{
The current implementation does not take into account jump or missing codes, the function is rather based on checking whether NAs are present in the study data
}
