% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fast_functions.r
\name{fast_is_equal}
\alias{fast_is_equal}
\title{Fast checks of equality}
\usage{
fast_is_equal(object1, object2)
}
\arguments{
\item{object1}{An element, a vector, a data.frame, a data.table}

\item{object2}{An element, a vector, a data.frame, a data.table}
}
\value{
Logical (TRUE or FALSE) if the two objects are equals.
}
\description{
Performs quick check if two objects are equal.
}
\details{
This function uses exponential search trick, so it is fast for very large vectors, data.frame and data.table.
This function is also very robust; you can compare a lot of stuff without failing.
}
\examples{
# Test on a character
fast_is_equal("a", "a")
fast_is_equal("a", "b")

# Test on a vector
myVector <- rep(x = "a", 10000)
fast_is_equal(myVector, myVector)

# Test on a data.table
fast_is_equal(tiny_messy_adult, messy_adult)
}
