% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_dm.R
\name{validate_drift_dm}
\alias{validate_drift_dm}
\title{Validate a DDM object}
\usage{
validate_drift_dm(drift_dm_obj)
}
\arguments{
\item{drift_dm_obj}{the ddm object}
}
\value{
the ddm object, after it passed all checks. Usually, it will be unmodified.
The only exception is when the observed RTs are larger than \code{t_max}. Then,
the returned ddm object has a new \code{t_max}that covers the largest RTs.
}
\description{
Performs basic checks to ensure everything is as expected with the model.
This function should be called whenever modifying a ddm object!
}
\details{
Checks:
\itemize{
\item The flex_prms_object via \code{\link[=validate_flex_prms]{validate_flex_prms()}}
\item The prms_solve (that it is a named numeric vector
\code{\link[=check_if_named_numeric_vector]{check_if_named_numeric_vector()}} with the expected entries) and
that nt, nx make sense. This may adjust t_max if t_max is smaller than
max(RT) of the observed data
\item The solver string (only a single string and that it refers to something
that is actually implemented). If im_zero, then check if dirac delta
on 0.
\item The cost_function string (only a single string and that it refers to
something that is actually implemented).
\item If cost_function is a summary statistic, that the objects stats_agg
exists and has the correct structure.
\item That the list comp_funs only contains functions and that each
function provides the expected arguments
\item If PDFs exist, the names, lengths and data type
\item If cost_val exists, if it is a single numeric
\item If obs_data exists, the data type, names, and structure
\item The b_coding (column, u_name_value and l_name_value).
}
}
\keyword{internal}
