% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_stats.R
\name{resample_helpers}
\alias{resample_helpers}
\alias{stats_resample_wrapper}
\alias{resample_assemble}
\title{Internal Helpers for Resampling of Summary Statistics}
\usage{
stats_resample_wrapper(
  obs_data_split,
  one_set_idxs = NULL,
  type,
  b_coding,
  ...
)

resample_assemble(resample_list, level, original)
}
\arguments{
\item{obs_data_split}{a named list of \link{data.frame}s, containing a single set
of observed data, splitted by condition}

\item{one_set_idxs}{a named list of numeric vectors. Each entry contains
indices to shuffle the \link{data.frame}s in \code{obs_data_split}. Default \code{NULL}
keeps \code{obs_data_split} as is.}

\item{type}{a character, passed to \code{\link[=calc_stats_pred_obs]{calc_stats_pred_obs()}}.}

\item{b_coding}{a list with boundary coding information,
, required to wrangle rts to match with \code{\link[=calc_stats_pred_obs]{calc_stats_pred_obs()}}.}

\item{...}{additional arguments passed to \code{\link[=calc_stats_pred_obs]{calc_stats_pred_obs()}}.}

\item{resample_list}{a list of statistics returned by calls to
\code{stats_resample_wrapper()}.}

\item{level}{a numeric between 0 and 1, controlling the width of the interval.}

\item{original}{a \code{stats_dm} object representing the statistic computed
from the original data set or model prediction.}
}
\value{
\itemize{
\item \code{stats_resample_wrapper()} returns a single \code{stats_dm} object for one
sample.
\item \code{resample_assemble()} returns a \code{stats_dm} object containing the lower
and upper interval bounds along with the original estimate.
}
}
\description{
These functions support the construction of intervals for
descriptive statistics computed from observed or simulated
data. They are used internally by \code{\link[=stats_resample_dm]{stats_resample_dm()}} methods.
}
\details{
\code{stats_resample_wrapper()} wraps a call to \code{calc_stats_pred_obs()} for use
in resampling.

\code{resample_assemble()} takes a list of resampled statistics and the
original statistic, and computes lower and upper bounds based
on the requested level. It returns a \code{stats_dm} object with an
added \code{Estimate} column.
}
\keyword{internal}
