% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_cost_functions.R
\name{calc_rmse_eval}
\alias{calc_rmse_eval}
\alias{calc_rmse}
\title{RMSE Calculation and Helpers}
\usage{
calc_rmse_eval(pdfs, t_vec, dt, stats_agg, stats_agg_info, weight_err = 1.5)

calc_rmse(quants_pred, cafs_pred, quants_obs, cafs_obs, weight_err = 1.5)
}
\arguments{
\item{pdfs}{list of PDFs per condition (named).}

\item{t_vec}{numeric time vector.}

\item{dt}{numeric time step.}

\item{stats_agg}{list of observed summary statistics.}

\item{stats_agg_info}{list with info on quantile probabilities and CAF bins.}

\item{weight_err}{non-negative numeric scalar; weight factor for CAF error
relative to quantile error. Default is 1.5}

\item{quants_pred}{numeric vector of predicted quantiles (already flattened).}

\item{cafs_pred}{numeric vector of predicted CAFs (already flattened).}

\item{quants_obs}{numeric vector of observed quantiles (already flattened).}

\item{cafs_obs}{numeric vector of observed CAFs (already flattened).}
}
\value{
A single numeric RMSE value, or \code{NULL} if no observed stats were
provided, or \code{Inf} if predictions failed (contain \code{NA}).
}
\description{
Internal helpers for computing the root mean squared error (RMSE) between
predicted and observed quantiles and conditional accuracy
functions.
}
\details{
\itemize{
\item \code{calc_rmse_eval()} prepares observed and predicted quantiles/CAFs from PDFs
and aggregated info, then calls \code{calc_rmse()}.
\item \code{calc_rmse()} computes the weighted RMSE given predicted and observed
quantiles/CAFs.
}
}
\seealso{
\code{\link[=stats_from_pdfs_agg_info]{stats_from_pdfs_agg_info()}}
}
\keyword{internal}
