% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvd_api_functions.R
\name{cvd_area_system_level}
\alias{cvd_area_system_level}
\title{List system levels available for a specific time period}
\usage{
cvd_area_system_level(time_period_id)
}
\arguments{
\item{time_period_id}{Integer (required). The ID of the reporting time period for which system levels should be returned. Use \code{\link[=cvd_time_period_list]{cvd_time_period_list()}} to find valid IDs.}
}
\value{
A tibble containing system level details for the specified time period, with the following columns:
\describe{
\item{IsVisible}{Logical or character. Indicates whether the system level is visible in the API or dashboard ("Y" or "N").}
\item{NationalLevel}{Logical or character. Indicates whether the system level represents national coverage ("Y" or "N").}
\item{SystemLevelID}{Integer. Unique identifier for the system level (e.g., 1 = England, 4 = PCN).}
\item{SystemLevelName}{Character. Name of the system level (e.g., "England", "Region", "ICB", "Practice").}
\item{SystemLevelOrder}{Integer. Display order for the system level in dashboards or reports.}
}
If no data is found, returns a tibble describing the error.
}
\description{
Retrieves all available NHS system levels (e.g., National, Region, ICB, PCN, Practice) for a specified reporting time period from the CVDPREVENT API.

This function helps users determine which system levels are available for data extraction in a given reporting period.
}
\details{
This function is useful in workflows where you need to filter or subset NHS areas or data by both time period and system level. It is often used as a precursor to more detailed area or indicator queries.
}
\note{
This function may take longer than 5 seconds to complete due to API response time.
}
\section{API Documentation}{

See the \href{https://bmchealthdocs.atlassian.net/wiki/spaces/CP/pages/317882369/CVDPREVENT+API+Documentation#\%2Farea\%2FsystemLevel}{CVDPREVENT API documentation: System levels per time period}
}

\examples{
\donttest{
# List all system levels available for time period 4 (activity to March 2022)
cvd_area_system_level(time_period_id = 4) |>
  dplyr::select(SystemLevelID, SystemLevelName)

# Find valid time period IDs, then get system levels for the latest one
latest_period <-
  cvd_time_period_system_levels() |>
  dplyr::pull(TimePeriodID) |>
  max()

cvd_area_system_level(time_period_id = latest_period) |>
  dplyr::select(SystemLevelID, SystemLevelName)
}

}
\seealso{
\code{\link[=cvd_area_details]{cvd_area_details()}}, \code{\link[=cvd_area_unassigned]{cvd_area_unassigned()}}, \code{\link[=cvd_area_search]{cvd_area_search()}}, \code{\link[=cvd_area_nested_subsystems]{cvd_area_nested_subsystems()}}, \code{\link[=cvd_area_flat_subsystems]{cvd_area_flat_subsystems()}}, \code{\link[=cvd_time_period_system_levels]{cvd_time_period_system_levels()}}
}
