% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write-utf8.R
\name{write_utf8}
\alias{write_utf8}
\alias{write_utf8_raw}
\title{Write UTF8 string}
\usage{
write_utf8(con, x, from = "")

write_utf8_raw(con, x, from = "")
}
\arguments{
\item{con}{Connection object or raw vector. When con is a raw vector, new
data will be \emph{appended} to the vector and returned.
Connection objects can be 
created with \code{file()}, \code{url()}, 
\code{rawConnection()} or any of the other many connection creation
functions.}

\item{x}{single character string}

\item{from}{current encoding. Argument is passed to \code{iconv()}. 
Default: "" (empty string) works well for most inputs. 
See documentaiton for \code{iconv()} for more information.}
}
\value{
If \code{con} is a connection then this connection is returned invisibly.
        If \code{con} is a raw vector then new data is appended to this vector
}
\description{
\code{write_utf8_raw()} writes the string without a nul-terminator.
\code{write_utf8()} includes a nul-terminator
}
\examples{
con <- file(tempfile(), "wb")
write_utf8(con, "hello")
close(con)
}
\seealso{
Other data output functions: 
\code{\link{fprintf}()},
\code{\link{write_f64}()},
\code{\link{write_hex}()},
\code{\link{write_raw}()},
\code{\link{write_uint8}()}
}
\concept{data output functions}
