% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3methods.R
\name{plot.ctsmTMB.fit}
\alias{plot.ctsmTMB.fit}
\title{This function creates residual plots for an estimated ctsmTMB object}
\usage{
\method{plot}{ctsmTMB.fit}(
  x,
  print.plot = 1,
  type = "residuals",
  state.type = "prior",
  against.obs = NULL,
  ggtheme = getggplot2theme(),
  ylims = c(NA, NA),
  residual.burnin = 0L,
  residual.vs.obs.and.inputs = FALSE,
  ...
)
}
\arguments{
\item{x}{A R6 ctsmTMB fit object}

\item{print.plot}{a single integer determining which element out of all
states/observations (depending on the argument to \code{type}).}

\item{type}{a character vector either 'residuals' or 'states' determining what
to plot.}

\item{state.type}{a character vector either 'prior', 'posterior' or 'smoothed'
determining what kind of states to plot.}

\item{against.obs}{name of an observation to plot state predictions against.}

\item{ggtheme}{ggplot2 theme to use for creating the ggplot.}

\item{ylims}{limits on the y-axis for residual time-series plot}

\item{residual.burnin}{integer N to remove the first N residuals}

\item{residual.vs.obs.and.inputs}{the residual plots also include a new window
with time-series plots of residuals, associated observations and inputs}

\item{...}{additional arguments}
}
\value{
a (list of) ggplot residual plot(s)
}
\description{
This function creates residual plots for an estimated ctsmTMB object
}
\examples{
library(ctsmTMB)
model <- ctsmTMB$new()

# create model
model$addSystem(dx ~ theta * (mu+u-x) * dt + sigma_x*dw)
model$addObs(y ~ x)
model$setVariance(y ~ sigma_y^2)
model$addInput(u)
model$setParameter(
  theta   = c(initial = 1, lower=1e-5, upper=50),
  mu      = c(initial=1.5, lower=0, upper=5),
  sigma_x = c(initial=1, lower=1e-10, upper=30),
  sigma_y = 1e-2
)
model$setInitialState(list(1,1e-1))

# fit model to data
fit <- model$estimate(Ornstein)

# plot residuals
\dontrun{plot(fit)}

# plot filtered states
\dontrun{plot(fit, type="states")}
}
