% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfMergeVariablesRelevel.R
\name{dfMergeVariablesRelevel}
\alias{dfMergeVariablesRelevel}
\title{Merge variables, keeping type where possible, optionally relevel factors}
\usage{
dfMergeVariablesRelevel(df = NULL, colnames = "", levelslist = NULL)
}
\arguments{
\item{df}{A \link{data.frame} with the variables (columns) to be merged into
one vector.}

\item{colnames}{A vector of names of columns in `df` that hold the variables
to be merged, or a selection of columns as per \code{\link[dplyr]{select}}.}

\item{levelslist}{A names list with one slice each for a new value to be
used for a vector of old values (optional).}
}
\value{
A vector, with the type of the columns to be merged
}
\description{
Merge variables in a data frame such as returned by \link{dbGetFieldsIntoDf}
into a new variable, and optionally also map its values to new levels.
See \link{ctrdata-trial-concepts} for pre-defined cross-register concepts
that are already implemented based on merging fields from different
registers and calculating a new field.
}
\examples{

dbc <- nodbi::src_sqlite(
  dbname = system.file("extdata", "demo.sqlite", package = "ctrdata"),
  collection = "my_trials",
  flags = RSQLite::SQLITE_RO)

df <- dbGetFieldsIntoDf(
  fields = c(
    "ctrname",
    "protocolSection.eligibilityModule.healthyVolunteers",
    "f31_healthy_volunteers",
    "eligibility.healthy_volunteers",
    "participants.participantType",
    paste0(
      "authorizedPartI.trialDetails.trialInformation.",
      "populationOfTrialSubjects.clinicalTrialGroups.name"
    ),
    paste0(
      "authorizedApplication.authorizedPartI.trialDetails.trialInformation.",
      "populationOfTrialSubjects.clinicalTrialGroups.name"
    )
  ),
  con = dbc
)

df$isrctnhealthy <- "Healthy volunteer" == df[, 6]
df$ctis1healthy <- "Healthy volunteers" == df[ ,7]
df$ctis2healthy <- "Healthy volunteers" == df[, 8]

table(
  df$ctrname,
  dfMergeVariablesRelevel(
    df = df,
    colnames = 'matches("healthy")'
))

}
