% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/silhouette.ct.R
\name{silhouette.ct}
\alias{silhouette.ct}
\title{Silhouettes for continuous-time k-means clustering}
\usage{
silhouette.ct(kmobj, ngrid = 5000)
}
\arguments{
\item{kmobj}{continuous-time k-means clustering from \code{\link{kmeans.ct}}}

\item{ngrid}{number of equally spaced grid points at which to compute the silhouette index}
}
\value{
Object of class "\code{silhouette.ct}", a list consisting of
\item{grid }{grid of \code{ngrid} points spanning the time range} 
\item{value }{silhouette index at each point along the grid} 
\item{transitions }{transition points between segments}
\item{cluster }{cluster memberships in the segments defined by the transitions}
\item{mean }{mean silhouette index}
}
\description{
Computes the silhouette index, at a grid of time points, for a continuous-time 
k-means clustering object produced by \code{\link{kmeans.ct}}.
}
\note{
An error is issued if the grid of time points contains one or more of the 
cluster transition points. This should not ordinarily occur, but if it does, it can 
be remedied by modifying \code{ngrid}.
}
\seealso{
\code{\link{kmeans.ct}}, which includes an example; \code{\link{plot.silhouette.ct}}
}
\author{
Philip Tzvi Reiss <reiss@stat.haifa.ac.il>
}
