% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cso_get_meta.R
\name{cso_get_var_values}
\alias{cso_get_var_values}
\title{Returns a list of the values of variables of a CSO data table}
\usage{
cso_get_var_values(table_code, cache = FALSE, flush_cache = TRUE)
}
\arguments{
\item{table_code}{string. A valid code for a table on data.cso.ie .}

\item{cache}{logical. Whether to use cached data, if available.
Default value is FALSE.}

\item{flush_cache}{logical. If TRUE (default) the cache will be checked for old, unused
files. Any files which have not been accessed in the last month will be deleted}
}
\value{
list. It has length equal to the number of variables in the table,
and each element is a character vector which has all the values taken by
one variable.
}
\description{
Reads the table to determine all the unique values taken by the
variables in the table and returns them as a list.
}
\examples{
\dontrun{
var_val <- cso_get_var_values("IPA03")
}

}
