% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_norway_municip.R
\docType{data}
\name{nor_municip_map_bxxxx_split_dt}
\alias{nor_municip_map_bxxxx_split_dt}
\alias{nor_municip_map_b2024_split_dt}
\alias{nor_municip_map_b2020_split_dt}
\title{Split map of Norwegian municipalities in data.table format}
\format{
\describe{
\item{long}{Location code.}
\item{lat}{Location name.}
\item{order}{The order that this line should be plotted in.}
\item{group}{Needs to be used as 'group' aesthetic in ggplot2.}
\item{location_code}{Location code (municipality code).}
}

An object of class \code{data.table} (inherits from \code{data.frame}) with 30601 rows and 5 columns.
}
\usage{
nor_municip_map_b2024_split_dt

nor_municip_map_b2020_split_dt
}
\description{
We conveniently package map datasets for Norwegian municipalities
(taken from Geonorge) that can be used in ggplot2 without needing any geo
libraries. This data is licensed under Creative Commons BY 4.0 (CC BY 4.0).
}
\details{
Borders for 2024 and 2020 are provided.
}
\examples{
# 2024 borders
library(ggplot2)
q <- ggplot(mapping = aes(x = long, y = lat))
q <- q + geom_polygon(
  data = csmaps::nor_municip_map_b2024_split_dt,
  mapping = aes(group = group),
  color = "black",
  fill = "white",
  linewidth = 0.2
)
q <- q + theme_void()
q <- q + coord_quickmap()
q

# 2020 borders
library(ggplot2)
q <- ggplot(mapping = aes(x = long, y = lat))
q <- q + geom_polygon(
  data = csmaps::nor_municip_map_b2020_split_dt,
  mapping = aes(group = group),
  color = "black",
  fill = "white",
  linewidth = 0.2
)
q <- q + theme_void()
q <- q + coord_quickmap()
q
}
\keyword{datasets}
