% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation.R
\name{create_nuisance}
\alias{create_nuisance}
\title{Create a nuisance specification}
\usage{
create_nuisance(
  fit,
  predict,
  train_fold = 1L,
  fit_deps = NULL,
  pred_deps = NULL
)
}
\arguments{
\item{fit}{A function \code{fit(data, ...)} that trains the nuisance
model on a subset of the data and returns a fitted model object.}

\item{predict}{A function \code{predict(model, data, ...)} that
returns predictions for the nuisance on new data.}

\item{train_fold}{Positive integer giving the width (in folds) of the
training window used for this nuisance. Defaults to \code{1L}.}

\item{fit_deps}{Optional named character vector mapping
\code{fit()} argument names to nuisance names, used to specify
nuisance inputs to the \code{fit} function. If \code{NULL}, the
dependencies are inferred later from required arguments whose names
match nuisance names.}

\item{pred_deps}{Optional named character vector mapping
\code{predict()} argument names to nuisance names, used to specify
nuisance inputs to the \code{predict} function.}
}
\value{
A list representing a nuisance specification, suitable for
inclusion in the \code{list_nuisance} argument of
\code{\link{create_method}}.
}
\description{
Helper to create a nuisance specification with basic structural
checks. A nuisance is defined by a \code{fit} function, a
\code{predict} function, and optional dependency mappings.
}
\examples{
# Simple linear regression nuisance: E[Y | X]
set.seed(1)
n <- 50
x <- rnorm(n)
y <- x + rnorm(n)

nuis <- create_nuisance(
  fit = function(data, ...) lm(y ~ x, data = data),
  predict = function(model, data, ...) predict(model, newdata = data)
)

str(nuis)
}
