% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ratios.r
\name{add_credit_ratios}
\alias{add_credit_ratios}
\title{Add credit ratios for debt service, interest cover, debt yield, and forward loan-to-value}
\usage{
add_credit_ratios(
  cf_tab,
  debt_sched,
  exit_yield,
  covenants = NULL,
  dscr_basis = c("noi", "gei", "cfads"),
  cfads_ti_lc = NULL,
  ignore_balloon_in_min = FALSE,
  maturity_year = NULL
)
}
\arguments{
\item{cf_tab}{A data.frame or tibble of project cash flows over years 0..N,
typically the output of \code{dcf_calculate()} or \code{cf_make_full_table()}.
It must at least contain a \code{year} column and either
\code{net_operating_income} or \code{gei}. When available, the following
columns are used:
\code{opex}, \code{cf_pre_debt}, \code{capex_recur}, \code{leasing_costs},
\code{loan_init}.}

\item{debt_sched}{A data.frame or tibble representing the debt schedule,
typically the output of \code{debt_built_schedule()}. It must contain
\code{year}, \code{payment}, \code{interest}, and \code{outstanding_debt},
and may also include \code{debt_draw} and \code{loan_init}.}

\item{exit_yield}{Numeric scalar; exit yield (in decimal form, for example
0.05) used to compute forward values as \code{NOI_next / exit_yield}.}

\item{covenants}{Optional list with elements \code{dscr_min}, \code{ltv_max}
and/or \code{debt_yield_min}. When supplied, the function adds simple
covenant indicators to the output table.}

\item{dscr_basis}{Character string specifying the numerator used for DSCR.
One of \code{"noi"}, \code{"gei"} or \code{"cfads"}. The default is
\code{"noi"}.}

\item{cfads_ti_lc}{Optional object used to construct a CFADS adjustment for
tenant-improvement or leasing-cost allowances. If a list, the element
\code{annual_allowance} (numeric scalar or vector) is subtracted from NOI.
If a function, it is called as \code{cfads_ti_lc(cf_tab)} and the returned
numeric vector is subtracted from NOI.}

\item{ignore_balloon_in_min}{Logical scalar. If \code{TRUE} and
\code{maturity_year} is not \code{NULL}, the attribute
\code{"min_dscr_pre_maturity"} is attached to the result and stores the
minimum DSCR computed only over years 1 to \code{maturity_year - 1},
ignoring any balloon repayment at maturity.}

\item{maturity_year}{Optional integer scalar giving the contractual maturity
year of the facility. Periods with \code{year > maturity_year} are treated
as post-maturity (no outstanding debt, no payment, no interest). This
parameter is required when \code{ignore_balloon_in_min = TRUE}.}
}
\value{
A tibble equal to \code{cf_tab} with the following additional
columns:
\itemize{
\item \code{gei}, \code{noi} (created if missing),
\item \code{payment}, \code{interest}, \code{outstanding_debt},
\item \code{noi_fwd}, \code{value_forward},
\item \code{dscr}, \code{interest_cover_ratio},
\item \code{debt_yield_init}, \code{debt_yield_current},
\item \code{ltv_forward},
\item covenant indicators when \code{covenants} is supplied.
}
When \code{ignore_balloon_in_min = TRUE} and \code{maturity_year} is
provided, the object also carries an attribute
\code{"min_dscr_pre_maturity"} containing the minimum DSCR before maturity.
}
\description{
Align a project cash-flow table with a debt schedule and compute
standard credit ratios for each period:
\itemize{
\item debt service coverage ratio (DSCR),
\item interest cover ratio (ICR),
\item initial and current debt yield,
\item forward loan-to-value (LTV) based on next-period NOI.
}
Optionally, simple covenant flags are added when threshold values
are supplied.
}
\examples{
cf_tab <- data.frame(
  year = 0:3,
  gei  = c(0, 120, 123, 126),
  opex = c(0, 40, 41, 42),
  loan_init = c(2000, NA, NA, NA)
)

debt_sched <- data.frame(
  year = 0:3,
  payment = c(0, 150, 150, 2150),
  interest = c(0, 100, 95, 90),
  outstanding_debt = c(2000, 2000, 1950, 1900),
  debt_draw = c(2000, 0, 0, 0)
)

out <- add_credit_ratios(
  cf_tab = cf_tab,
  debt_sched = debt_sched,
  exit_yield = 0.05,
  covenants = list(dscr_min = 1.10, ltv_max = 0.70)
)

out

}
