% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_doc.R
\docType{data}
\name{cps_factors}
\alias{cps_factors}
\title{Sample factor specifications for reading CPS data}
\format{
A data frame with 204 rows and 8 columns:
\describe{
\item{year}{year}
\item{cps_name}{original column name as given by the CPS}
\item{new_name}{a new name, which tries to describe the variable and join
sensibly across multiple years}
\item{code}{the numeric code contained in the raw CPS data}
\item{value}{the character value corresponding to each numeric code}
}
}
\usage{
cps_factors
}
\description{
Because the CPS changes factor levels across years, to correctly read the data
you have to specify which numeric codes correspond to which character values
in each year. This is one such specification. To add extra data, see the Vignette.
}
\details{
These match the exact specifications from the CPS, including NA codes
and any typos that occur (e.g., "Hipsanic" is common in older years).
}
\keyword{datasets}
