% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_r.R
\name{to_r}
\alias{to_r}
\alias{to_r,CppSet-method}
\alias{to_r,CppUnorderedSet-method}
\alias{to_r,CppMultiset-method}
\alias{to_r,CppUnorderedMultiset-method}
\alias{to_r,CppMap-method}
\alias{to_r,CppUnorderedMap-method}
\alias{to_r,CppMultimap-method}
\alias{to_r,CppUnorderedMultimap-method}
\alias{to_r,CppStack-method}
\alias{to_r,CppQueue-method}
\alias{to_r,CppPriorityQueue-method}
\alias{to_r,CppVector-method}
\alias{to_r,CppDeque-method}
\alias{to_r,CppForwardList-method}
\alias{to_r,CppList-method}
\title{Export data to R}
\usage{
to_r(x, n = NULL, from = NULL, to = NULL)
}
\arguments{
\item{x}{A \code{cppcontainers} object.}

\item{n}{The number of elements to export. If \code{n} is positive it exports elements starting at the front of the container. If \code{n} is negative, 
it starts at the back. Negative values only work on CppSet, CppMultiset, CppMap, CppMultimap, CppVector, CppDeque, and CppList objects.}

\item{from}{The first value in CppSet, CppMultiset, CppMap, CppMultimap objects to export. If it is not a member of \code{x}, the export starts at the 
subsequent value. In a CppVector or CppDeque object, \code{from} marks the index of the first element to export. Ignored for other classes.}

\item{to}{The last value in CppSet, CppMultiset, CppMap, CppMultimap objects to export. If it is not a member of \code{x}, the export ends with the 
prior value. In a CppVector or CppDeque object, \code{from} marks the index of the last element to export. Ignored for other classes.}
}
\value{
Returns a vector in case of CppSet, CppUnorderedSet, CppMultiset, CppUnorderedMultiset, CppStack, CppQueue, CppPriorityQueue, CppVector, 
CppDeque, CppForwardList, and CppList objects. Returns a data frame in case of CppMap, CppUnorderedMap, CppMultimap, and CppUnorderedMultimap objects.
}
\description{
Export C++ data to an R object.
}
\details{
\code{to_r} has side effects, when applied to stacks, queues, or priority queues. These container types are not iterable. Hence, 
\strong{\code{to_r} removes elements from the CppStack, CppQueue, and CppPriorityQueue objects when exporting them to R}. When \code{n} is specified, 
the method removes the top \code{n} elements from a stack or priority queue or the first \code{n} elements from a queue. Otherwise, it removes all 
elements. Other container types, like sets, etc., are unaffected.
}
\examples{
s <- cpp_set(11:20)
to_r(s)
# [1] 11 12 13 14 15 16 17 18 19 20

to_r(s, n = 4)
# [1] 11 12 13 14

to_r(s, n = -4)
# [1] 20 19 18 17

to_r(s, from = 14)
# [1] 14 15 16 17 18 19 20

to_r(s, to = 18)
# [1] 11 12 13 14 15 16 17 18

to_r(s, from = 14, to = 18)
# [1] 14 15 16 17 18

m <- cpp_unordered_multimap(c("hello", "hello", "there"), 4:6)
to_r(m)
#     key value
# 1 there     6
# 2 hello     4
# 3 hello     5

s <- cpp_stack(11:20)
to_r(s, n = 3)
# [1] 20 19 18
s
# Top element: 17

}
\seealso{
\link{print}, \link{sorting}, \link{type}.
}
