% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mle.R
\name{mlePath}
\alias{mlePath}
\title{Maximum Likelihood Estimator Paths}
\usage{
mlePath(
  y,
  max.iter = 10000,
  max.iter.nr = 100,
  tol = 1e-06,
  tol.nr = 1e-06,
  lambda.gl = NULL,
  lambda.min.ratio = 0.1,
  n.lambda = 1,
  n.cores = 1,
  gamma = 0.1,
  lr.penalty = c("alr", "clr")
)
}
\arguments{
\item{y}{Matrix of counts; samples are rows and features are columns.}

\item{max.iter}{Maximum number of iterations}

\item{max.iter.nr}{Maximum number of Newton-Raphson iterations}

\item{tol}{Stopping rule}

\item{tol.nr}{Stopping rule for the Newton Raphson algorithm}

\item{lambda.gl}{Vector of penalization parameters lambda, for the graphical lasso penalty}

\item{lambda.min.ratio}{Minimum lambda ratio of the maximum lambda,
used for the sequence of lambdas}

\item{n.lambda}{Number of lambdas to evaluate the model on}

\item{n.cores}{Number of cores to use (for parallel computation)}

\item{gamma}{Gamma value for EBIC calculation of the log-likelihood}

\item{lr.penalty}{Should the precision matrix be penalized on the ALR or CLR scale?}
}
\value{
The MLE estimates of \code{y} for each element lambda of lambda.gl, (\code{est});
the value of the estimates which produce the minimum EBIC, (\code{est.min});
the vector of lambdas used for graphical lasso, (\code{lambda.gl}); the index of
the minimum EBIC (extended Bayesian information criterion), (\code{min.idx});
vector containing the EBIC for each lambda, (\code{ebic}).
}
\description{
Calculates the maximum likelihood estimates of the parameters for the
mutlinomial logit-Normal distribution under various values
of the penalization parameter \code{lambda}. Parameter \code{lambda} controls
the sparsity of the covariance matrix \code{Sigma}, and penalizes the false
large correlations that may arise in high-dimensional data.
}
\note{
If using parallel computing, consider setting \code{n.cores} to be equal
to the number of lambdas being evaluated for, \code{n.lambda}.

The graphical lasso penalty
is the sum of the absolute value of the elements of the covariance matrix \code{Sigma}.
The penalization parameter lambda controls the sparsity of Sigma.
}
\examples{
data(singlecell)
mle.sim <- mlePath(singlecell, tol=1e-4, tol.nr=1e-4, n.lambda = 2, n.cores = 1)

mu.hat <- mle.sim$est.min$mu
Sigma.hat <- mle.sim$est.min$Sigma

}
