% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cop_cmdscale.R
\name{cop_cmdscale}
\alias{cop_cmdscale}
\title{PCOPS version of strain}
\usage{
cop_cmdscale(
  dis,
  theta = 1,
  type = "ratio",
  weightmat = NULL,
  ndim = 2,
  init = NULL,
  itmaxi = 1000,
  add,
  ...,
  stressweight = 1,
  cordweight = 0.5,
  q = 1,
  minpts = ndim + 1,
  epsilon = 10,
  rang = NULL,
  verbose = 0,
  scale = "sd",
  normed = TRUE
)
}
\arguments{
\item{dis}{numeric matrix or dist object of a matrix of proximities}

\item{theta}{the theta vector of powers; this must be a scalar of the lambda transformation for the observed proximities.}

\item{type}{MDS type. Ignored here.}

\item{weightmat}{(optional) a matrix of nonnegative weights}

\item{ndim}{number of dimensions of the target space}

\item{init}{(optional) initial configuration}

\item{itmaxi}{number of iterations. No effect here.}

\item{add}{should the dissimilarities be made Euclidean? Defaults to TRUE.}

\item{...}{additional arguments to be passed to the fitting procedure smacofx::cmdscale. Note we always use eig=TRUE and that can't be changed (we need the GOF). Also default if nothing is supplied is to use add=TRUE which in my opinion one always should to avoid negative eigenvalues.}

\item{stressweight}{weight to be used for the fit measure; defaults to 1}

\item{cordweight}{weight to be used for the cordillera; defaults to 0.5}

\item{q}{the norm of the corrdillera; defaults to 1}

\item{minpts}{the minimum points to make up a cluster in OPTICS; defaults to ndim+1}

\item{epsilon}{the epsilon parameter of OPTICS, the neighbourhood that is checked; defaults to 10}

\item{rang}{range of the distances (min distance minus max distance). If NULL (default) the cordillera will be normed to each configuration's maximum distance, so an absolute value of goodness-of-clusteredness.}

\item{verbose}{numeric value hat prints information on the fitting process; >2 is extremely verbose}

\item{scale}{should the configuration be scale adjusted}

\item{normed}{should the cordillera be normed; defaults to TRUE}
}
\value{
A list with the components
\itemize{
        \item stress: the badness-of-fit value (this isn't stress here but 1-(sum_ndim(max(eigenvalues,0))/sum_n(max(eigenvalues,0)), 1-GOF[2])
        \item stress.m: default normalized stress (manually calculated)
        \item copstress: the weighted loss value
        \item OC: the Optics cordillera value
        \item parameters: the parameters used for fitting (lambda)
        \item fit: the returned object of the fitting procedure, which is cmdscalex object with some extra slots for the parameters and stresses 
        \item cordillera: the cordillera object
}
}
\description{
The free parameter that pcops optimizes over is lambda for power transformations of the observed proximities.
}
\keyword{multivariate}
