% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnt_generics.R, R/fs_methods.R,
%   R/logger_generics.R
\name{upload_cnt}
\alias{upload_cnt}
\alias{upload_cnt.ConnectorFS}
\alias{upload_cnt.ConnectorLogger}
\title{Upload content to the connector}
\usage{
upload_cnt(
  connector_object,
  src,
  dest = basename(src),
  overwrite = zephyr::get_option("overwrite", "connector"),
  ...
)

\method{upload_cnt}{ConnectorFS}(
  connector_object,
  src,
  dest = basename(src),
  overwrite = zephyr::get_option("overwrite", "connector"),
  ...
)

\method{upload_cnt}{ConnectorLogger}(
  connector_object,
  src,
  dest = basename(src),
  overwrite = zephyr::get_option("overwrite", "connector"),
  ...
)
}
\arguments{
\item{connector_object}{\link{Connector} The connector object to use.}

\item{src}{\link{character} Path to the file to download to or upload from}

\item{dest}{\link{character} Name of the content to read, write, or remove. Typically the table name.}

\item{overwrite}{Overwrite existing content if it exists in the connector?
See \link{connector-options} for details. Default can be set globally with
\code{options(connector.overwrite = TRUE/FALSE)} or environment variable
\code{R_CONNECTOR_OVERWRITE}.. Default: \code{FALSE}.}

\item{...}{Additional arguments passed to the method for the individual connector.}
}
\value{
\link{invisible} connector_object.
}
\description{
Generic implementing of how to upload files to a connector:

\itemize{
\item \link{ConnectorFS}: Uses \code{\link[fs:copy]{fs::file_copy()}} to copy the \code{file} to the file storage.
}

\itemize{
\item \link{ConnectorLogger}: Logs the upload operation and calls the underlying connector method.
}
}
\examples{
# Upload file to a file storage

writeLines("this is an example", "example.txt")

folder <- withr::local_tempdir("test", .local_envir = .GlobalEnv)

cnt <- connector_fs(folder)

cnt |>
  list_content_cnt(pattern = "example.txt")

cnt |>
  upload_cnt("example.txt")

cnt |>
  list_content_cnt(pattern = "example.txt")

cnt |>
  remove_cnt("example.txt")

file.remove("example.txt")

# Add logging to a file system connector for uploads
folder <- withr::local_tempdir("test", .local_envir = .GlobalEnv)

cnt <- connectors(data = connector_fs(folder)) |> add_logs()

# Create a temporary file
temp_file <- tempfile(fileext = ".csv")
write.csv(iris, temp_file, row.names = FALSE)

cnt$data |>
  upload_cnt(temp_file, "uploaded_iris.csv")

}
