% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connector_imports.R, R/table_methods.R,
%   R/volume_methods.R
\name{write_cnt}
\alias{write_cnt}
\alias{write_cnt.ConnectorDatabricksTable}
\alias{write_cnt.ConnectorDatabricksVolume}
\title{Write content to the connector}
\usage{
write_cnt(
  connector_object,
  x,
  name,
  overwrite = zephyr::get_option("overwrite", "connector"),
  ...
)

\method{write_cnt}{ConnectorDatabricksTable}(
  connector_object,
  x,
  name,
  overwrite = zephyr::get_option("overwrite", "connector.databricks"),
  ...,
  method = "volume",
  tags = NULL
)

\method{write_cnt}{ConnectorDatabricksVolume}(
  connector_object,
  x,
  name,
  overwrite = zephyr::get_option("overwrite", "connector.databricks"),
  ...
)
}
\arguments{
\item{connector_object}{\link[connector]{Connector} The connector object to use.}

\item{x}{The object to write to the connection}

\item{name}{\link{character} Name of the content to read, write, or remove. Typically the table name.}

\item{overwrite}{Overwrite existing content if it exists in the connector.}

\item{...}{\link{ConnectorDatabricksVolume}: Additional parameters to pass to the
\code{\link[brickster:db_volume_write]{brickster::db_volume_write()}} method}

\item{method}{\itemize{
\item \link{ConnectorDatabricksTable}: Which method to use for writing the
table. Options:
\itemize{
\item \code{volume} - using temporary volume to write data and then convert it
to a table.
}
}}

\item{tags}{\itemize{
\item \link{ConnectorDatabricksTable}: Named list containing tag names
and tag values, e.g.
\code{list("tag_name1" = "tag_value1", "tag_name2" = "tag_value2")}.
More info \href{https://docs.databricks.com/aws/en/database-objects/tags}{here}
}}
}
\value{
\link{invisible} connector_object.
}
\description{
Additional write methods for Databricks connectors implemented for
\code{\link[connector:write_cnt]{connector::write_cnt()}}:

\itemize{
\item \link{ConnectorDatabricksTable}: Reuses the \code{\link[connector:write_cnt]{connector::write_cnt()}}
method for \link{ConnectorDatabricksTable}, but always
sets the \code{catalog} and \code{schema} as defined in when initializing the
connector. Creates temporary volume to write object as a
parquet file and then convert it to a table.
}

\itemize{
\item \link{ConnectorDatabricksVolume}: Reuses the \code{\link[connector:write_cnt]{connector::write_cnt()}}
method for \link{ConnectorDatabricksVolume}, but always
sets the \code{catalog}, \code{schema} and \code{path} as defined in when initializing the
connector.
}
}
