% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluspath.R
\name{clusPath}
\alias{clusPath}
\alias{kmeansPath}
\alias{pamPath}
\alias{claraPath}
\alias{medoidPath}
\alias{centroidPath}
\title{Constructs  tours of data space based on centers of clusters}
\usage{
kmeansPath(data, length = 10, reorder = TRUE, conditionvars = NULL, ...)

pamPath(
  data,
  length = 10,
  reorder = TRUE,
  conditionvars = NULL,
  maxn = 4000,
  ...
)

claraPath(data, length = 10, reorder = TRUE, conditionvars = NULL, ...)

medoidPath(data, cl, reorder = FALSE)

centroidPath(data, cl, reorder = FALSE)
}
\arguments{
\item{data}{A dataframe}

\item{length}{Path length, defaults to 10}

\item{reorder}{If TRUE  uses DendSer to reorder the path \code{\link[DendSer]{dser}}}

\item{conditionvars}{A vector of variable names. The returned tour is for this subset of variables.}

\item{...}{ignored}

\item{maxn}{(pamPath only) For datasets with more than maxn rows, use maxn randomly selected rows.}

\item{cl}{A vector specifying cluster membership for rows of data.}
}
\value{
A dataframe with the path
}
\description{
Constructs  tours of data space based on centers of clusters
}
\section{Functions}{
\itemize{
\item \code{kmeansPath()}: Constructs a tour of data space following  length k-means centroids

\item \code{pamPath()}: Constructs a tour of data space following  length \code{\link[cluster]{pam}} medoids

\item \code{claraPath()}: Constructs a tour of data space following  length \code{\link[cluster]{clara}} medoids

\item \code{medoidPath()}: Returns a path visiting cluster medoids

\item \code{centroidPath()}: Returns a path visiting cluster centroids

}}
\examples{
kmeansPath(mtcars,length=4)
pamPath(mtcars,length=4)
claraPath(mtcars,length=4)
medoidPath(mtcars,cl=rep(1:3, length.out=nrow(mtcars)))
}
