% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmd_assign.R
\name{cmd_assign}
\alias{cmd_assign}
\alias{cmd_assign_quiet}
\title{Assign Values Passed at the Command Line or Interactively}
\usage{
cmd_assign(...)

cmd_assign_quiet(...)
}
\arguments{
\item{...}{Name-value pairs.}
}
\value{
\code{cmd_assign()} is called
for its side effect, which is to create objects
in the global environment. However, \code{cmd_assign()}
also invisibly returns a named list of objects.
}
\description{
Assign values to names in the working environment.
The values are typically supplied through the command line,
but can be supplied interactively.

Specifying the inputs and outputs of scripts through the
command line can contribute to safter, more modular
workflows.

\code{cmd_assign_quiet()} is identical to \code{cmd_assign()},
but does not print progress messages to the console.
}
\section{Types of session}{
\code{cmd_assign()} behaves differently depending
on how it whether it is called
\enumerate{
\item interactively, or
\item inside an R script that is run from the command line.
}

For instance, if the code

\code{cmd_assign(use_log = TRUE)}

is run interactively, it creates an object
called \code{use_log} with value \code{TRUE}.

But if the same code is run inside a
script via the command

\verb{Rscript tidy_data.R --use_log=FALSE}

it creates an object called \code{use_log}
with value \code{FALSE}.

\code{cmd_assign()} is typically called interactively
when a workflow is being developed,
and through the command line when the
workflow has matured.
}

\section{Matching names and values}{
When used in a script called from the
command line, \code{cmd_assign()}
first matches named command line arguments,
and then matches unnamed command line arguments,
in the order in which they are supplied.

If, for instance, the script \code{person.R} contains
the lines

\if{html}{\out{<div class="sourceCode">}}\preformatted{cmd_assign(.data = "raw_data.csv",
           max_age = 85,
           .out = "person.rds")
}\if{html}{\out{</div>}}

and if \code{person.R} is run from the command line using

\if{html}{\out{<div class="sourceCode">}}\preformatted{Rscript person.R raw_data.csv person.rds --max_age=100
}\if{html}{\out{</div>}}

then \code{cmd_assign()} first matches named
command line argument \code{--max_age=100} to \verb{cmd_assign() argument }max_age\verb{, and then matches unnamed command line arguments }raw_data.csv\code{and}person.rds\code{to}cmd_assign()\code{arugments}.data\code{and}.out`.
}

\section{Coercing values passed at the command line}{
Values passed at the command line start out as
text strings. \code{cmd_assign()} coerces these text strings
to have the same class as the corresponding values
in the call to \code{cmd_assign()}. For instance,
if a script called \code{fit.R} contains
the lines

\if{html}{\out{<div class="sourceCode">}}\preformatted{cmd_assign(.data = "cleaned.rds",
           impute = TRUE,
           date = as.Date("2026-01-01"),
           .out = "fit.rds")
}\if{html}{\out{</div>}}

and if \code{fitted.R} is run from the command line using

\if{html}{\out{<div class="sourceCode">}}\preformatted{Rscript fitted.R cleaned.rds fit.rds --impute=TRUE --date=2025-01-01
}\if{html}{\out{</div>}}

then \code{cmd_assign()} will create
\itemize{
\item a character vector called \code{.data} with value "cleaned.rds",
\item a logical vector called \code{impute} with value \code{TRUE},
\item a date vector called \code{date} with value \code{"2025-01-01"}, and
\item a character vector called \code{.out} with value `"fit.rds".
}
}

\examples{
if (interactive()) {
  cmd_assign(.data = "mydata.csv",
             n_iter = 2000,
             .out = "results.rds")
}
}
\references{
\itemize{
\item \href{https://swcarpentry.github.io/r-novice-inflammation/05-cmdline.html}{Command-Line Programs}
Introduction to Rscript
}
}
\seealso{
\itemize{
\item \code{\link[=extract_shell]{extract_shell()}} Turn a \code{cmd_assign()} call into a shell command
\item \code{\link[=extract_make]{extract_make()}} Turn a \code{cmd_assign()} call into a Makefile rule
\item \code{\link[=shell_script]{shell_script()}} Create a shell script
\item \code{\link[=makefile]{makefile()}} Create a Makefile
\item \href{https://bayesiandemography.github.io/command/articles/quickstart.html}{Quick Start}
How to use \code{cmd_assign()}
\item \href{https://bayesiandemography.github.io/command/articles/workflow.html}{Modular Workflows for Data Analysis}
Safe, flexible data analysis workflows.
\item Base R function \code{\link[=commandArgs]{commandArgs()}} uses a more general,
lower-level approach to processing command line arguments.
(\code{commandArgs()} is called internally by \code{cmd_assign()}.)
\item \href{https://CRAN.R-project.org/package=littler}{littler} Alternative to Rscript
}
}
