% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_arg_preference_order.R
\name{validate_arg_preference_order}
\alias{validate_arg_preference_order}
\title{Check and complete argument \code{preference_order}}
\usage{
validate_arg_preference_order(
  df = NULL,
  response = NULL,
  predictors = NULL,
  preference_order = NULL,
  quiet = FALSE,
  function_name = NULL,
  ...
)
}
\arguments{
\item{df}{(required; dataframe, tibble, or sf) A dataframe with responses
(optional) and predictors. Must have at least 10 rows for pairwise
correlation analysis, and \code{10 * (length(predictors) - 1)} for VIF.
Default: NULL.}

\item{response}{(optional, character string) Name of a numeric response variable in \code{df}. Default: NULL.}

\item{predictors}{(optional; character vector or NULL) Names of the
predictors in \code{df}. If NULL, all columns except \code{responses} and
constant/near-zero-variance columns are used. Default: NULL.}

\item{preference_order}{(optional; character vector, dataframe from
\code{\link{preference_order}}, or NULL) Prioritizes predictors to preserve.}

\item{quiet}{(optional; logical) If FALSE, messages are printed. Default: FALSE.}

\item{function_name}{(optional, character string) Name of the function performing the argument check. Default: NULL}

\item{...}{(optional) Internal args (e.g. \code{function_name} for
\code{\link{validate_arg_function_name}}, a precomputed correlation matrix
\code{m}, or cross-validation args for \code{\link{preference_order}}).}
}
\value{
character vector: ranked variable names
}
\description{
Internal function to validate the argument \code{preference_order} in \code{\link[=cor_select]{cor_select()}}, \code{\link[=vif_select]{vif_select()}}, \code{\link[=collinear_select]{collinear_select()}}, \code{\link[=collinear]{collinear()}}, and \code{\link[=collinear]{collinear()}}. Predictors not in \code{preference_order} are ranked from lower to higher sum of Pearson correlations with all other predictors.
}
\examples{
data(
  vi_smol,
  vi_predictors_numeric
  )

#input arguments must be validated first
df <- validate_arg_df(
  df = vi_smol,
  response = "vi_numeric",
  predictors = vi_predictors_numeric,
  quiet = TRUE
)

response <- validate_arg_responses(
  df = df,
  responses = "vi_numeric"
)

predictors <- validate_arg_predictors(
  df = df,
  response = response,
  predictors = vi_predictors_numeric[1:10]
)



#no preference order
#no response
#ranks predictor from lower to higher multicollinearity
y <- validate_arg_preference_order(
  df = df,
  predictors = predictors,
  preference_order = NULL
)

y
attributes(y)$validated


#validate character vector
y <- validate_arg_preference_order(
  df = df,
  predictors = predictors,
  preference_order = c(
    "swi_max",
    "swi_min",
    "swi_deviance" #does not exist
  )
)

y
attributes(y)$validated

#validate output of preference order
x <- preference_order(
  df = df,
  responses = response,
  predictors = predictors
)

x

y <- validate_arg_preference_order(
  df = df,
  response = response,
  predictors = predictors,
  preference_order = x
)

y
attributes(y)$validated
}
\seealso{
Other argument_validation: 
\code{\link{drop_geometry_column}()},
\code{\link{validate_arg_df}()},
\code{\link{validate_arg_df_not_null}()},
\code{\link{validate_arg_encoding_method}()},
\code{\link{validate_arg_f}()},
\code{\link{validate_arg_function_name}()},
\code{\link{validate_arg_max_cor}()},
\code{\link{validate_arg_max_vif}()},
\code{\link{validate_arg_predictors}()},
\code{\link{validate_arg_quiet}()},
\code{\link{validate_arg_responses}()}
}
\concept{argument_validation}
