% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identify_categorical_variables.R
\name{identify_categorical_variables}
\alias{identify_categorical_variables}
\title{Find valid categorical variables in a dataframe}
\usage{
identify_categorical_variables(
  df = NULL,
  responses = NULL,
  predictors = NULL,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{df}{(required; dataframe, tibble, or sf) A dataframe with responses
(optional) and predictors. Must have at least 10 rows for pairwise
correlation analysis, and \code{10 * (length(predictors) - 1)} for VIF.
Default: NULL.}

\item{responses}{(optional; character, character vector, or NULL) Name of
one or several response variables in \code{df}. Default: NULL.}

\item{predictors}{(required, character vector) Names of the predictors to identify. Default: NULL}

\item{quiet}{(optional; logical) If FALSE, messages are printed. Default: FALSE.}

\item{...}{(optional) Internal args (e.g. \code{function_name} for
\code{\link{validate_arg_function_name}}, a precomputed correlation matrix
\code{m}, or cross-validation args for \code{\link{preference_order}}).}
}
\value{
list:
\itemize{
\item \code{valid}: character vector with valid categorical predictor names.
\item \code{invalid}: character vector with invalid categorical predictor names due to degenerate cardinality (1 or \code{nrow(df)} categories).
}
}
\description{
Identifies valid and invalid character or factor variables. Invalid categorical predictors are those with a single category, or as many categories as cases (full-cardinality).
}
\examples{

data(vi_smol, vi_predictors)

#create an invalid categorical
vi_smol$invalid_categorical <- "a"

x <- identify_categorical_variables(
  df = vi_smol,
  responses = "vi_categorical",
  predictors = vi_predictors
)

x$valid
x$invalid

}
\seealso{
Other data_types: 
\code{\link{identify_logical_variables}()},
\code{\link{identify_numeric_variables}()},
\code{\link{identify_response_type}()},
\code{\link{identify_valid_variables}()},
\code{\link{identify_zero_variance_variables}()}
}
\author{
Blas M. Benito, PhD
}
\concept{data_types}
