% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_binomial_rf.R
\name{f_binomial_rf}
\alias{f_binomial_rf}
\title{Area Under the Curve of Binomial Random Forest predictions vs. observations}
\usage{
f_binomial_rf(df, ...)
}
\arguments{
\item{df}{(required, dataframe) with columns:
\itemize{
\item "x": (numeric, character, factor) predictor.
\item "y" (integer) binomial response with unique values 0 and 1.
}}

\item{...}{(optional) Accepts the arguments \code{cv_training_fraction} (numeric between 0 and 1) and \code{cv_iterations} (integer between 1 and Inf) for cross validation.}
}
\value{
numeric or numeric vector: AUC
}
\description{
Fits a univariate random forest model \code{y ~ x} with the binomial (values 0 and 1) response \code{y} and the numeric, character or factor predictor \code{x} using \code{ranger::ranger()} and returns the area under the ROC curve between the observed responses and the model predictions (see \code{\link[=score_auc]{score_auc()}}).

Cases are weighted with \code{\link[=case_weights]{case_weights()}} to prevent issues arising from class imbalance.

Supports cross-validation via the arguments arguments \code{cv_training_fraction} (numeric between 0 and 1) and \code{cv_iterations} (integer between 1 and \code{n}) introduced via ellipsis (\code{...}). See \code{\link[=preference_order]{preference_order()}} for further details.
}
\examples{
data(vi_smol)

df <- data.frame(
  y = vi_smol[["vi_binomial"]],
  x = vi_smol[["swi_max"]]
)

#no cross-validation
f_binomial_rf(df = df)

#cross-validation
f_binomial_rf(
  df = df,
  cv_training_fraction = 0.5,
  cv_iterations = 10
  )

#categorical predictor
df <- data.frame(
  y = vi_smol[["vi_binomial"]],
  x = vi_smol[["koppen_zone"]]
)

f_binomial_rf(df = df)

}
\seealso{
Other preference_order_functions: 
\code{\link{f_binomial_gam}()},
\code{\link{f_binomial_glm}()},
\code{\link{f_categorical_rf}()},
\code{\link{f_count_gam}()},
\code{\link{f_count_glm}()},
\code{\link{f_count_rf}()},
\code{\link{f_numeric_gam}()},
\code{\link{f_numeric_glm}()},
\code{\link{f_numeric_rf}()},
\code{\link{preference_order}()}
}
\concept{preference_order_functions}
