% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IH.R
\name{dIH}
\alias{dIH}
\title{Density of Irwin-Hall distribution}
\usage{
dIH(x, m, log = FALSE)
}
\arguments{
\item{x}{vector of quantities, between 0 and m}

\item{m}{integer, parameter}

\item{log}{logical, return log density if TRUE}
}
\value{
(log) density evaluated at x
}
\description{
Irwin-Hall distribution is defined as a sum of m uniform (0,1) distribution.
Its density is given as
\deqn{
  f(x;m) = \frac{1}{(m-1)!}\sum_{k=0}^{m} (-1)^k {m \choose k} \max(0,x-k)^{m-1}, 0 < x < m
}
The density of Bates distribution, defined as an average of m uniform (0,1) distribution, can be obtained from change-of-variable (y = x/m),
\deqn{
  h(y;m) = \frac{m}{(m-1)!}\sum_{k=0}^{m} (-1)^k {m \choose k} \max(0,my-k)^{m-1}, 0 < y < 1
}
}
\details{
Due to alternating series representation, m > 80 may yield numerical issues
}
\examples{
m = 8
xgrid= seq(0, m, length = 500)
hist(colSums(matrix(runif(m*1000), nrow = m, ncol = 1000)), freq = FALSE) 
lines(xgrid, dIH(xgrid, m, log = FALSE))
# Bates distribution
xgrid= seq(0, 1, length = 500)
hist(colMeans(matrix(runif(m*1000), nrow = m, ncol = 1000)), freq = FALSE) 
lines(xgrid, m*dIH(xgrid*m, m, log = FALSE))

}
