% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoFAST.R
\name{AddCluster}
\alias{AddCluster}
\title{Find clusters for SRT data}
\usage{
AddCluster(
  seu,
  reduction = "cofast",
  cluster.name = "cofast.cluster",
  res = 0.8,
  K = NULL,
  res.start = 0.2,
  res.end = 2,
  step = 0.02
)
}
\arguments{
\item{seu}{a Seurat object.}

\item{reduction}{a optional string, dimensional reduction name, `cofast` by default.}

\item{cluster.name}{an optional string, specify the colname in meta.data for clusters, `cofast.cluster` by default.}

\item{res}{a positive real, speficy the resolution parameter for Louvain clustering, default as 0.8.}

\item{K}{a positive integer or NULL, specify the number of clusters, default as NULL that indicates not specify the number of clusters.}

\item{res.start}{a positive real, when K is not NULL, starting value of resolution to be searched, default as 0.2.}

\item{res.end}{a positive real, when K is not NULL, ending value of resolution to be searched, default as 2.}

\item{step}{a positive real, when K is not NULL, step size of resolution to be searched, default as 0.02.}
}
\value{
return  a revised Seurat object with a new column in meta.data named cluster.name.
}
\description{
Identify clusters of spots by a shared nearest neighbor (SNN) modularity optimization based on coFAST's embeddings.
}
\details{
None
}
\examples{
library(Seurat)
data(pbmc3k_subset)
pbmc3k_subset <- AddCluster(pbmc3k_subset, reduction='ncfm')
head(pbmc3k_subset)
}
\references{
None
}
\seealso{
None
}
