% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoFAST.R
\name{AddAdj}
\alias{AddAdj}
\title{Calculate the adjacency matrix given a spatial coordinate matrix}
\usage{
AddAdj(
  pos,
  type = "fixed_distance",
  platform = c("Others", "Visium", "ST"),
  neighbors = 6,
  ...
)
}
\arguments{
\item{pos}{a matrix object, with columns representing the spatial coordinates that can be any diemsion, i.e., 2, 3 and >3.}

\item{type}{an optional string, specify which type of neighbors' definition. Here we provide two definition: one is "fixed_distance", the other is "fixed_number".}

\item{platform}{a string, specify the platform of the provided data, default as "Others". There are more platforms to be chosen, including "Visuim", "ST" and "Others" ("Others" represents the other SRT platforms except for 'Visium' and 'ST')
The platform helps to calculate the adjacency matrix by defining the neighborhoods when type="fixed_distance" is chosen.}

\item{neighbors}{an optional postive integer,  specify how many neighbors used in calculation, default as 6.}

\item{...}{Other arguments passed to \code{\link[DR.SC]{getAdj_auto}}.}
}
\value{
return a sparse matrix, representing the adjacency matrix.
}
\description{
Calculate the adjacency matrix given a spatial coordinate matrix with 2-dimension or 3-dimension or more.
}
\details{
When the type = "fixed_distance", then the spots within the Euclidean distance cutoffs from one spot are regarded as the neighbors of this spot. When the type = "fixed_number", the K-nearest spots are regarded as the neighbors of each spot.
}
\examples{
data(CosMx_subset)
pos <- as.matrix(CosMx_subset@meta.data[,c("x", "y")])
Adj_sp <- AddAdj(pos)


}
\references{
None
}
\seealso{
None
}
