% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_data.R
\name{prepare_stan_data_symmetric}
\alias{prepare_stan_data_symmetric}
\title{Prepare data for symmetric threshold Stan model}
\usage{
prepare_stan_data_symmetric(
  formula,
  data,
  link = "logit",
  link_param = NULL,
  prior_beta_sd = 2.5,
  prior_cpos_sd = 5
)
}
\arguments{
\item{formula}{A formula specifying the model}

\item{data}{A data frame containing the variables}

\item{link}{Link function name}

\item{link_param}{A list of link parameters (for flexible links)}

\item{prior_beta_sd}{Prior SD for regression coefficients (default: 2.5)}

\item{prior_cpos_sd}{Prior SD for positive thresholds (default: 5)}
}
\value{
A list suitable for passing to CmdStan (clm_symmetric.stan)
}
\description{
Creates a Stan data list for cumulative link models with symmetric
thresholds centered at 0: \code{c[k] = -c[K-k]}
}
\details{
Examples:
\itemize{
\item K=4 (3 thresholds): c = (-a, 0, a)
\item K=5 (4 thresholds): c = (-b, -a, a, b)
\item K=6 (5 thresholds): c = (-b, -a, 0, a, b)
}
}
\keyword{internal}
