% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{plot.clmstan}
\alias{plot.clmstan}
\title{Plot method for clmstan objects}
\usage{
\method{plot}{clmstan}(
  x,
  type = c("trace", "dens", "hist", "areas", "intervals", "acf"),
  pars = NULL,
  ...
)
}
\arguments{
\item{x}{A clmstan object}

\item{type}{Type of plot: "trace" (default), "dens", "hist", "areas",
"intervals", or "acf" (autocorrelation).}

\item{pars}{Character vector of parameter names to plot. If NULL, plots
beta, c_transformed (except first), and beta0.}

\item{...}{Additional arguments passed to bayesplot functions.
For "acf" type, you can use \code{lags} to control the number of lags.}
}
\value{
A ggplot object
}
\description{
Produces diagnostic plots using the bayesplot package.
}
\examples{
\dontrun{
fit <- clm_stan(rating ~ temp, data = wine)
plot(fit)                    # trace plots
plot(fit, type = "dens")     # density plots
plot(fit, type = "intervals") # credible intervals
plot(fit, type = "acf")      # autocorrelation plots
plot(fit, pars = "beta")     # only beta parameters
}

}
