% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select.R
\name{select}
\alias{select}
\title{Single Selection Menu}
\usage{
select(
  choices,
  prompt = "Select an item:",
  selected = NULL,
  return_index = FALSE,
  max_visible = 10L
)
}
\arguments{
\item{choices}{Character vector of choices to display}

\item{prompt}{Prompt message to display}

\item{selected}{Pre-selected item (index or value)}

\item{return_index}{Return index instead of value (default: FALSE)}

\item{max_visible}{Maximum number of items to display at once (default: 10).
Set to NULL to show all items.}
}
\value{
Selected item as character or index, or NULL if cancelled
}
\description{
Interactive menu for selecting a single item from a list.
Uses arrow keys (or j/k) to navigate and Enter to select.
}
\examples{
if (interactive()) {
  choice <- select(c("Yes", "No", "Maybe"))
  index <- select(c("First", "Second", "Third"), return_index = TRUE)

  # With scrolling for long lists
  choice <- select(1:100, max_visible = 10)
}
}
