% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LocalEstim.R
\name{LocalEstim}
\alias{LocalEstim}
\title{Local bootstrap estimation of EVI, scale and T-year levels}
\usage{
LocalEstim(
  Data,
  drc,
  thr = NULL,
  thetaGrid,
  nBoot = 100,
  EVIestimator = "Mom",
  h = 30,
  useKernel = TRUE,
  concent = 10,
  movThr = TRUE,
  TTs = NULL,
  timeRange = NULL
)
}
\arguments{
\item{Data}{Response variable}

\item{drc}{Directional covariate}

\item{thr}{Threshold values along thetaGrid}

\item{thetaGrid}{Grid values at which the estimation is performed}

\item{nBoot}{Number of bootstrap resamples. Default to 100.}

\item{EVIestimator}{It can be either "ML" or "Mom"}

\item{h}{Bandwidth value}

\item{useKernel}{Logical. If TRUE (default), use kernel to assign weights
depending on the directional distance.}

\item{concent}{Concentration parameter value for von Mises kernel}

\item{movThr}{Logical. If TRUE (default), moving threshold within the window
used.}

\item{TTs}{T-year levels. For example, TTs = c(100, 10000).}

\item{timeRange}{Time range of the sample}
}
\value{
List including bootstrap estimates of EVI, scale and T-year levels.
}
\description{
Local bootstrap estimation of EVI, scale and T-year levels
}
\details{
See Konzen, E., Neves, C., and Jonathan, P. (2021). Modeling nonstationary extremes of storm severity: Comparing parametric and semiparametric inference. Environmetrics, 32(4), e2667.
}
\examples{
data(HsSP)
data(drc)
timeRange <- 54.5

idx <- order(drc)
drc <- drc[idx]
Data <- HsSP[idx]
set.seed(1234)
Data <- Data + runif(length(Data), -1e-4, 1e-4)

thetaVec <- 1:360

data(thresholdExampleMom) # loads threshold example
thrResultMom <- thresholdExampleMom

\donttest{

h <- 60
useKernel <- TRUE
concent <- 10
movThr <- TRUE
nBoot <- 30
set.seed(1234)
output <- LocalEstim(Data=Data, drc=drc, thr=thrResultMom,
                     thetaGrid=thetaVec, nBoot=nBoot, EVIestimator="Mom", h=h,
                     useKernel=useKernel, concent=concent, movThr=movThr,
                     TTs=c(100, 10000), timeRange=timeRange)

RLBoot <- output$RLBoot

PlotParamEstim(bootEstimates=output$xiBoot, thetaGrid=thetaVec, ylab=bquote(hat(xi)),
               alpha=0.05, ylim=NULL, cex.axis=15, cex.lab=2, thrWidth=2)

PlotParamEstim(bootEstimates=output$sigBoot, thetaGrid=thetaVec, ylab=bquote(hat(sigma)),
               alpha=0.05, ylim=NULL, cex.axis=15, cex.lab=2, thrWidth=2)

# 100-year level
PlotRL(RLBootList=RLBoot, thetaGrid=thetaVec, Data=Data, drc=drc,
       TTs=c(100, 10000), whichPlot=1, alpha=0.05, ylim=NULL,
       pointSize=1, cex.axis=15, cex.lab=2, thrWidth=2)

PolarPlotRL(RLBootList=RLBoot, thetaGrid=thetaVec, Data=Data, drc=drc,
            TTs=c(100, 10000), whichPlot=1, alpha=0.05, ylim=NULL,
            pointSize=4, fontSize=12, lineWidth=2)

}

## See examples in vignette:
# vignette("localMethods", package = "circularEV")
}
