% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/move_mwall.R
\name{move_to_mwall}
\alias{move_to_mwall}
\title{Move data locations to the medial wall}
\usage{
move_to_mwall(xifti, values = c(NA, NaN), drop = FALSE)
}
\arguments{
\item{xifti}{A \code{"xifti"} object.}

\item{values}{Medial wall values. Default: \code{NA} and \code{NaN}. Data
locations in the left and right cortex that are one of these values (across
all columns) will be moved to the medial wall mask in the metadata.}

\item{drop}{Only used if the \code{"xifti"} has the dlabel intent. Drop the
key(s) in \code{values} from the label tables, for columns in which they no
longer exist? Default: \code{FALSE}.}
}
\value{
The \code{"xifti"} with re-organized data and medial wall masks
}
\description{
Move cortical data locations with a specific value(s) to the medial wall mask.
For example, dlabel CIFTIs often have medial wall vertices set to a specific
key value, rather than a medial wall mask. This function can move those data
locations from the data matrix to the medial wall mask in the metadata.
}
\seealso{
move_from_mwall

Other manipulating xifti: 
\code{\link{add_surf}()},
\code{\link{apply_parc}()},
\code{\link{apply_xifti}()},
\code{\link{combine_xifti}()},
\code{\link{convert_xifti}()},
\code{\link{impute_xifti}()},
\code{\link{merge_xifti}()},
\code{\link{move_to_submask}()},
\code{\link{newdata_xifti}()},
\code{\link{remap_cifti}()},
\code{\link{remove_xifti}()},
\code{\link{resample_cifti}()},
\code{\link{resample_cifti_from_template}()},
\code{\link{scale_xifti}()},
\code{\link{select_xifti}()},
\code{\link{set_names_xifti}()},
\code{\link{smooth_cifti}()},
\code{\link{transform_xifti}()}
}
\concept{manipulating xifti}
