% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choice_probabilities.R
\name{choiceprob_logit}
\alias{choiceprob_logit}
\title{Calculate logit choice probabilities}
\usage{
choiceprob_logit(
  X,
  y = NULL,
  Tp = NULL,
  beta,
  Omega = NULL,
  gamma = NULL,
  weights = NULL,
  input_checks = TRUE,
  ordered = !is.null(gamma),
  ranked = !ordered && !is.null(y) && length(y) > 0 && length(y[[1]]) > 1,
  panel = !is.null(Tp) && any(Tp > 1),
  lc = !is.null(weights),
  draws = NULL,
  n_draws = 200
)
}
\arguments{
\item{X}{[\code{list(N)}]\cr
A \code{list} of length \code{N} (number observations) of design matrices, each of
dimension \code{J} (number alternatives) times \code{P} (number effects).

In the ordered case (\code{ordered = TRUE}), the design matrices are of dimension
\code{1} times \code{P}.}

\item{y}{[\code{list(N)} | \code{NULL}]\cr
A \code{list} of length \code{N} (number observations) of single integers from \code{1} to
\code{J} (number alternatives).

In the ranked case (\code{ranked = TRUE}), the list entries each must be a
permutation of \code{1:J}, where the higher-ranked alternatives are in front.

In the non-panel case (\code{panel = FALSE}), \code{y} can also be \code{NULL}, in which
case probabilities are calculated for all choice alternatives.
In the ranked case (\code{ranked = TRUE}), if \code{y} is \code{NULL},
only first place choice probabilities are computed, which is equivalent to
computing choice probabilities in the regular (maximum utility) model.}

\item{Tp}{[\code{NULL} | \code{integer(N)}]\cr
The panel identifier of length \code{N} (number observations) for panel data.
The number \code{Tp[1]} indicates, that the first \code{Tp[1]} observations in \code{X} and
\code{y} belong to decider 1, the next \code{Tp[2]} observations belong to decider 2,
and so on.

Can be \code{NULL} for no panel data.}

\item{beta}{[\code{numeric(P)} | \code{list}]\cr
The coefficient vector of length \code{P} (number effects) for computing the
systematic utility \eqn{V = X\beta}.

In the latent class case (\code{lc = TRUE}), \code{beta} is a \code{list} of length \code{C} of
such coefficients, where \code{C} is the number of latent classes.}

\item{Omega}{[\code{matrix(nrow = P_r, ncol = P_r)} | \code{NULL} | \code{list}]\cr
The covariance matrix of random effects of dimension \code{P_r} times \code{P_r},
where \code{P_r} less than \code{P} is the number of random effects.

Can be \code{NULL} for no random effects.

In the latent class case (\code{lc = TRUE}), \code{Omega} is a \code{list} of length \code{C} of
such covariance matrices, where \code{C} is the number of latent classes.}

\item{gamma}{[\code{NULL} | \code{numeric(J - 1)}]\cr
Only relevant in the ordered case (\code{ordered = TRUE}). It defines the
non-decreasing boundaries of the utility categories.

The event \eqn{U \leq \gamma_j} means that alternative \eqn{j} is chosen,
while \eqn{U > \gamma_{J - 1}} means that alternative \eqn{J} is chosen.}

\item{weights}{[\code{NULL} | \code{numeric()}]\cr
Optional class weights for latent class specifications.}

\item{input_checks}{[\code{logical(1)}]\cr
Perform input checks. Set to \code{FALSE} to skip them.}

\item{ordered, ranked, panel, lc}{[\code{logical(1)}]\cr
Flags indicating whether the specification is ordered, ranked, panel, or
latent class. These defaults are inferred from the other inputs so callers
typically do not need to override them.}

\item{draws}{[\code{NULL} | \code{matrix} | \code{list}]\cr
Optional simulation draws for the random coefficients when \code{Omega} is not
\code{NULL}. A matrix provides shared draws for all classes; a list can supply
class-specific draw matrices.}

\item{n_draws}{[\code{integer(1)}]\cr
Number of draws to generate when \code{draws} is \code{NULL} and \code{Omega} is provided.}
}
\value{
A numeric vector with the choice probabilities for the observed choices when
\code{y} is supplied. If \code{y} is \code{NULL}, a matrix with one row per observation and
one column per alternative is returned.
}
\description{
These helper functions compute logit choice probabilities for unordered and
ordered outcomes. Panel inputs reuse the observation-level logit formulae,
which remain valid because the logit error term is independent across
occasions. Latent class models are supported via weighted averages of
class-specific probabilities. When \code{Omega} is supplied, the coefficients are
assumed to follow a multivariate normal distribution and the resulting
probabilities are evaluated by averaging over simulation draws.
}
\keyword{probability}
