% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine.replicates.R
\name{combine.replicates}
\alias{combine.replicates}
\title{combine.replicates}
\usage{
combine.replicates(replicates, method = c("sum", "weighted-sum"))
}
\arguments{
\item{replicates}{list of data table objects from \code{prepare.data}}

\item{method}{string specifying the method for merging replicates. Options are 'sum' and 'weighted-sum'.}
}
\value{
Data table object containing merged data, where counts are stored in colums
\item{count.i}{count of interaction in ith replicate}
\item{count}{count after merging replicates}
}
\description{
Merge biological replicates.
}
\details{
The parameter \code{method} determines which method is used for merging 
	replicates. Available options are weighted-sum and sum.

	'weighted-sum' implements the size factor scaling approach used in DEseq, 
	rounded to the closest integer. See Anders and Huber 2010 for details.
	
	'sum' is the naive sum of counts across biological replicates.
}
\examples{
\donttest{
if( bedtools.installed() ) {
	  # preprocess data
	  bam <- system.file('extdata', 'Bre80_2q35.bam', package = 'chicane');
	  baits <- system.file('extdata', '2q35.bed', package = 'chicane');
	  fragments <- system.file('extdata', 'GRCh38_HindIII_chr2.bed.gz', package = 'chicane');
	  input.data <- prepare.data(
	  bam = bam, 
	  baits = baits, 
	  fragments = fragments
	  );

	  # combined two datasets into one
  merged <- combine.replicates(list(input.data, input.data));
 }
}

}
\references{
Anders, Simon, and Wolfgang Huber. "Differential expression analysis for sequence count data." \emph{Genome biology} 11.10 (2010): R106.
}
